# Generated by default/object.tt
package Paws::CloudWatchEvents::CreateConnectionAuthRequestParameters;
  use Moose;
  has ApiKeyAuthParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::CreateConnectionApiKeyAuthRequestParameters');
  has BasicAuthParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::CreateConnectionBasicAuthRequestParameters');
  has InvocationHttpParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::ConnectionHttpParameters');
  has OAuthParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::CreateConnectionOAuthRequestParameters');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::CreateConnectionAuthRequestParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::CreateConnectionAuthRequestParameters object:

  $service_obj->Method(Att1 => { ApiKeyAuthParameters => $value, ..., OAuthParameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::CreateConnectionAuthRequestParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->ApiKeyAuthParameters

=head1 DESCRIPTION

Contains the authorization parameters for the connection.

=head1 ATTRIBUTES


=head2 ApiKeyAuthParameters => L<Paws::CloudWatchEvents::CreateConnectionApiKeyAuthRequestParameters>

A C<CreateConnectionApiKeyAuthRequestParameters> object that contains
the API key authorization parameters to use for the connection.


=head2 BasicAuthParameters => L<Paws::CloudWatchEvents::CreateConnectionBasicAuthRequestParameters>

A C<CreateConnectionBasicAuthRequestParameters> object that contains
the Basic authorization parameters to use for the connection.


=head2 InvocationHttpParameters => L<Paws::CloudWatchEvents::ConnectionHttpParameters>

A C<ConnectionHttpParameters> object that contains the API key
authorization parameters to use for the connection. Note that if you
include additional parameters for the target of a rule via
C<HttpParameters>, including query strings, the parameters added for
the connection take precedence.


=head2 OAuthParameters => L<Paws::CloudWatchEvents::CreateConnectionOAuthRequestParameters>

A C<CreateConnectionOAuthRequestParameters> object that contains the
OAuth authorization parameters to use for the connection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

