# Generated by default/object.tt
package Paws::CloudWatchEvents::HttpParameters;
  use Moose;
  has HeaderParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::HeaderParametersMap');
  has PathParameterValues => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has QueryStringParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::QueryStringParametersMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::HttpParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::HttpParameters object:

  $service_obj->Method(Att1 => { HeaderParameters => $value, ..., QueryStringParameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::HttpParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->HeaderParameters

=head1 DESCRIPTION

These are custom parameter to be used when the target is an API Gateway
REST APIs or EventBridge ApiDestinations. In the latter case, these are
merged with any InvocationParameters specified on the Connection, with
any values from the Connection taking precedence.

=head1 ATTRIBUTES


=head2 HeaderParameters => L<Paws::CloudWatchEvents::HeaderParametersMap>

The headers that need to be sent as part of request invoking the API
Gateway REST API or EventBridge ApiDestination.


=head2 PathParameterValues => ArrayRef[Str|Undef]

The path parameter values to be used to populate API Gateway REST API
or EventBridge ApiDestination path wildcards ("*").


=head2 QueryStringParameters => L<Paws::CloudWatchEvents::QueryStringParametersMap>

The query string keys/values that need to be sent as part of request
invoking the API Gateway REST API or EventBridge ApiDestination.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

