# Generated by default/object.tt
package Paws::CloudWatchEvents::ReplayDestination;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', required => 1);
  has FilterArns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::ReplayDestination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::ReplayDestination object:

  $service_obj->Method(Att1 => { Arn => $value, ..., FilterArns => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::ReplayDestination object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

A C<ReplayDestination> object that contains details about a replay.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

The ARN of the event bus to replay event to. You can replay events only
to the event bus specified to create the archive.


=head2 FilterArns => ArrayRef[Str|Undef]

A list of ARNs for rules to replay events to.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

