# Generated by default/object.tt
package Paws::Config::AggregateComplianceByConformancePack;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str');
  has AwsRegion => (is => 'ro', isa => 'Str');
  has Compliance => (is => 'ro', isa => 'Paws::Config::AggregateConformancePackCompliance');
  has ConformancePackName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Config::AggregateComplianceByConformancePack

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Config::AggregateComplianceByConformancePack object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., ConformancePackName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Config::AggregateComplianceByConformancePack object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Provides aggregate compliance of the conformance pack. Indicates
whether a conformance pack is compliant based on the name of the
conformance pack, account ID, and region.

A conformance pack is compliant if all of the rules in a conformance
packs are compliant. It is noncompliant if any of the rules are not
compliant. The compliance status of a conformance pack is
INSUFFICIENT_DATA only if all rules within a conformance pack cannot be
evaluated due to insufficient data. If some of the rules in a
conformance pack are compliant but the compliance status of other rules
in that same conformance pack is INSUFFICIENT_DATA, the conformance
pack shows compliant.

=head1 ATTRIBUTES


=head2 AccountId => Str

The 12-digit AWS account ID of the source account.


=head2 AwsRegion => Str

The source AWS Region from where the data is aggregated.


=head2 Compliance => L<Paws::Config::AggregateConformancePackCompliance>

The compliance status of the conformance pack.


=head2 ConformancePackName => Str

The name of the conformance pack.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Config>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

