# Generated by default/object.tt
package Paws::DS::ClientCertAuthSettings;
  use Moose;
  has OCSPUrl => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DS::ClientCertAuthSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DS::ClientCertAuthSettings object:

  $service_obj->Method(Att1 => { OCSPUrl => $value, ..., OCSPUrl => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DS::ClientCertAuthSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->OCSPUrl

=head1 DESCRIPTION

Contains information about the client certificate authentication
settings for the C<RegisterCertificate> and C<DescribeCertificate>
operations.

=head1 ATTRIBUTES


=head2 OCSPUrl => Str

Specifies the URL of the default OCSP server used to check for
revocation status. A secondary value to any OCSP address found in the
AIA extension of the user certificate.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

