# Generated by default/object.tt
package Paws::ECR::ReplicationDestination;
  use Moose;
  has Region => (is => 'ro', isa => 'Str', request_name => 'region', traits => ['NameInRequest'], required => 1);
  has RegistryId => (is => 'ro', isa => 'Str', request_name => 'registryId', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECR::ReplicationDestination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECR::ReplicationDestination object:

  $service_obj->Method(Att1 => { Region => $value, ..., RegistryId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECR::ReplicationDestination object:

  $result = $service_obj->Method(...);
  $result->Att1->Region

=head1 DESCRIPTION

An array of objects representing the details of a replication
destination.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Region => Str

A Region to replicate to.


=head2 B<REQUIRED> RegistryId => Str

The account ID of the destination registry to replicate to.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

