# Generated by default/object.tt
package Paws::ECS::DeploymentCircuitBreaker;
  use Moose;
  has Enable => (is => 'ro', isa => 'Bool', request_name => 'enable', traits => ['NameInRequest'], required => 1);
  has Rollback => (is => 'ro', isa => 'Bool', request_name => 'rollback', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECS::DeploymentCircuitBreaker

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECS::DeploymentCircuitBreaker object:

  $service_obj->Method(Att1 => { Enable => $value, ..., Rollback => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECS::DeploymentCircuitBreaker object:

  $result = $service_obj->Method(...);
  $result->Att1->Enable

=head1 DESCRIPTION

The deployment circuit breaker can only be used for services using the
rolling update (C<ECS>) deployment type that are not behind a Classic
Load Balancer.

The B<deployment circuit breaker> determines whether a service
deployment will fail if the service can't reach a steady state. If
enabled, a service deployment will transition to a failed state and
stop launching new tasks. You can also enable Amazon ECS to roll back
your service to the last completed deployment after a failure. For more
information, see Rolling update
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html)
in the I<Amazon Elastic Container Service Developer Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Enable => Bool

Whether to enable the deployment circuit breaker logic for the service.


=head2 B<REQUIRED> Rollback => Bool

Whether to enable Amazon ECS to roll back the service if a service
deployment fails. If rollback is enabled, when a service deployment
fails, the service is rolled back to the last deployment that completed
successfully.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

