# Generated by default/object.tt
package Paws::EMRContainers::VirtualCluster;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has ContainerProvider => (is => 'ro', isa => 'Paws::EMRContainers::ContainerProvider', request_name => 'containerProvider', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::EMRContainers::TagMap', request_name => 'tags', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMRContainers::VirtualCluster

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMRContainers::VirtualCluster object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMRContainers::VirtualCluster object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

This entity describes a virtual cluster. A virtual cluster is a
Kubernetes namespace that Amazon EMR is registered with. Amazon EMR
uses virtual clusters to run jobs and host endpoints. Multiple virtual
clusters can be backed by the same physical cluster. However, each
virtual cluster maps to one namespace on an EKS cluster. Virtual
clusters do not create any active resources that contribute to your
bill or that require lifecycle management outside the service.

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of the virtual cluster.


=head2 ContainerProvider => L<Paws::EMRContainers::ContainerProvider>

The container provider of the virtual cluster.


=head2 CreatedAt => Str

The date and time when the virtual cluster is created.


=head2 Id => Str

The ID of the virtual cluster.


=head2 Name => Str

The name of the virtual cluster.


=head2 State => Str

The state of the virtual cluster.


=head2 Tags => L<Paws::EMRContainers::TagMap>

The assigned tags of the virtual cluster.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMRContainers>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

