# Generated by default/object.tt
package Paws::GlobalAccelerator::CustomRoutingEndpointDescription;
  use Moose;
  has EndpointId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlobalAccelerator::CustomRoutingEndpointDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlobalAccelerator::CustomRoutingEndpointDescription object:

  $service_obj->Method(Att1 => { EndpointId => $value, ..., EndpointId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlobalAccelerator::CustomRoutingEndpointDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->EndpointId

=head1 DESCRIPTION

A complex type for an endpoint for a custom routing accelerator. Each
endpoint group can include one or more endpoints, which are virtual
private cloud (VPC) subnets.

=head1 ATTRIBUTES


=head2 EndpointId => Str

An ID for the endpoint. For custom routing accelerators, this is the
virtual private cloud (VPC) subnet ID.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlobalAccelerator>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

