
package Paws::Greengrass::UpdateConnectorDefinition;
  use Moose;
  has ConnectorDefinitionId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'ConnectorDefinitionId', required => 1);
  has Name => (is => 'ro', isa => 'Str');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'UpdateConnectorDefinition');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/greengrass/definition/connectors/{ConnectorDefinitionId}');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'PUT');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Greengrass::UpdateConnectorDefinitionResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Greengrass::UpdateConnectorDefinition - Arguments for method UpdateConnectorDefinition on L<Paws::Greengrass>

=head1 DESCRIPTION

This class represents the parameters used for calling the method UpdateConnectorDefinition on the
L<AWS Greengrass|Paws::Greengrass> service. Use the attributes of this class
as arguments to method UpdateConnectorDefinition.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to UpdateConnectorDefinition.

=head1 SYNOPSIS

    my $greengrass = Paws->service('Greengrass');
    my $UpdateConnectorDefinitionResponse =
      $greengrass->UpdateConnectorDefinition(
      ConnectorDefinitionId => 'My__string',
      Name                  => 'My__string',    # OPTIONAL
      );

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/greengrass/UpdateConnectorDefinition>

=head1 ATTRIBUTES


=head2 B<REQUIRED> ConnectorDefinitionId => Str

The ID of the connector definition.



=head2 Name => Str

The name of the definition.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method UpdateConnectorDefinition in L<Paws::Greengrass>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

