# Generated by default/object.tt
package Paws::Honeycode::Filter;
  use Moose;
  has ContextRowId => (is => 'ro', isa => 'Str', request_name => 'contextRowId', traits => ['NameInRequest']);
  has Formula => (is => 'ro', isa => 'Str', request_name => 'formula', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::Filter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::Filter object:

  $service_obj->Method(Att1 => { ContextRowId => $value, ..., Formula => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::Filter object:

  $result = $service_obj->Method(...);
  $result->Att1->ContextRowId

=head1 DESCRIPTION

An object that represents a filter formula along with the id of the
context row under which the filter function needs to evaluate.

=head1 ATTRIBUTES


=head2 ContextRowId => Str

The optional contextRowId attribute can be used to specify the row id
of the context row if the filter formula contains unqualified
references to table columns and needs a context row to evaluate them
successfully.


=head2 B<REQUIRED> Formula => Str

A formula representing a filter function that returns zero or more
matching rows from a table. Valid formulas in this field return a list
of rows from a table. The most common ways of writing a formula to
return a list of rows are to use the FindRow() or Filter() functions.
Any other formula that returns zero or more rows is also acceptable.
For example, you can use a formula that points to a cell that contains
a filter function.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

