# Generated by default/object.tt
package Paws::IoT::DetectMitigationActionsTaskTarget;
  use Moose;
  has BehaviorName => (is => 'ro', isa => 'Str', request_name => 'behaviorName', traits => ['NameInRequest']);
  has SecurityProfileName => (is => 'ro', isa => 'Str', request_name => 'securityProfileName', traits => ['NameInRequest']);
  has ViolationIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'violationIds', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::DetectMitigationActionsTaskTarget

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::DetectMitigationActionsTaskTarget object:

  $service_obj->Method(Att1 => { BehaviorName => $value, ..., ViolationIds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::DetectMitigationActionsTaskTarget object:

  $result = $service_obj->Method(...);
  $result->Att1->BehaviorName

=head1 DESCRIPTION

The target of a mitigation action task.

=head1 ATTRIBUTES


=head2 BehaviorName => Str

The name of the behavior.


=head2 SecurityProfileName => Str

The name of the security profile.


=head2 ViolationIds => ArrayRef[Str|Undef]

The unique identifiers of the violations.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

