# Generated by default/object.tt
package Paws::IoTEvents::EmailConfiguration;
  use Moose;
  has Content => (is => 'ro', isa => 'Paws::IoTEvents::EmailContent', request_name => 'content', traits => ['NameInRequest']);
  has From => (is => 'ro', isa => 'Str', request_name => 'from', traits => ['NameInRequest'], required => 1);
  has Recipients => (is => 'ro', isa => 'Paws::IoTEvents::EmailRecipients', request_name => 'recipients', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::EmailConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::EmailConfiguration object:

  $service_obj->Method(Att1 => { Content => $value, ..., Recipients => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::EmailConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Content

=head1 DESCRIPTION

Contains the configuration information of email notifications.

=head1 ATTRIBUTES


=head2 Content => L<Paws::IoTEvents::EmailContent>

Contains the subject and message of an email.


=head2 B<REQUIRED> From => Str

The email address that sends emails.

If you use the AWS IoT Events managed AWS Lambda function to manage
your emails, you must verify the email address that sends emails in
Amazon SES
(https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html).


=head2 B<REQUIRED> Recipients => L<Paws::IoTEvents::EmailRecipients>

Contains the information of one or more recipients who receive the
emails.

You must add the users that receive emails to your AWS SSO store
(https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

