# Generated by default/object.tt
package Paws::LakeFormation::DataLakeSettings;
  use Moose;
  has CreateDatabaseDefaultPermissions => (is => 'ro', isa => 'ArrayRef[Paws::LakeFormation::PrincipalPermissions]');
  has CreateTableDefaultPermissions => (is => 'ro', isa => 'ArrayRef[Paws::LakeFormation::PrincipalPermissions]');
  has DataLakeAdmins => (is => 'ro', isa => 'ArrayRef[Paws::LakeFormation::DataLakePrincipal]');
  has TrustedResourceOwners => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LakeFormation::DataLakeSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LakeFormation::DataLakeSettings object:

  $service_obj->Method(Att1 => { CreateDatabaseDefaultPermissions => $value, ..., TrustedResourceOwners => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LakeFormation::DataLakeSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->CreateDatabaseDefaultPermissions

=head1 DESCRIPTION

A structure representing a list of AWS Lake Formation principals
designated as data lake administrators and lists of principal
permission entries for default create database and default create table
permissions.

=head1 ATTRIBUTES


=head2 CreateDatabaseDefaultPermissions => ArrayRef[L<Paws::LakeFormation::PrincipalPermissions>]

A structure representing a list of up to three principal permissions
entries for default create database permissions.


=head2 CreateTableDefaultPermissions => ArrayRef[L<Paws::LakeFormation::PrincipalPermissions>]

A structure representing a list of up to three principal permissions
entries for default create table permissions.


=head2 DataLakeAdmins => ArrayRef[L<Paws::LakeFormation::DataLakePrincipal>]

A list of AWS Lake Formation principals. Supported principals are IAM
users or IAM roles.


=head2 TrustedResourceOwners => ArrayRef[Str|Undef]

A list of the resource-owning account IDs that the caller's account can
use to share their user access details (user ARNs). The user ARNs can
be logged in the resource owner's AWS CloudTrail log.

You may want to specify this property when you are in a high-trust
boundary, such as the same team or company.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LakeFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

