# Generated by default/object.tt
package Paws::LexRuntimeV2::SentimentScore;
  use Moose;
  has Mixed => (is => 'ro', isa => 'Num', request_name => 'mixed', traits => ['NameInRequest']);
  has Negative => (is => 'ro', isa => 'Num', request_name => 'negative', traits => ['NameInRequest']);
  has Neutral => (is => 'ro', isa => 'Num', request_name => 'neutral', traits => ['NameInRequest']);
  has Positive => (is => 'ro', isa => 'Num', request_name => 'positive', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::SentimentScore

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::SentimentScore object:

  $service_obj->Method(Att1 => { Mixed => $value, ..., Positive => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::SentimentScore object:

  $result = $service_obj->Method(...);
  $result->Att1->Mixed

=head1 DESCRIPTION

The individual sentiment responses for the utterance.

=head1 ATTRIBUTES


=head2 Mixed => Num

The level of confidence that Amazon Comprehend has in the accuracy of
its detection of the C<MIXED> sentiment.


=head2 Negative => Num

The level of confidence that Amazon Comprehend has in the accuracy of
its detection of the C<NEGATIVE> sentiment.


=head2 Neutral => Num

The level of confidence that Amazon Comprehend has in the accuracy of
its detection of the C<NEUTRAL> sentiment.


=head2 Positive => Num

The level of confidence that Amazon Comprehend has in the accuracy of
its detection of the C<POSITIVE> sentiment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

