# Generated by default/object.tt
package Paws::LookoutMetrics::DimensionContribution;
  use Moose;
  has DimensionName => (is => 'ro', isa => 'Str');
  has DimensionValueContributionList => (is => 'ro', isa => 'ArrayRef[Paws::LookoutMetrics::DimensionValueContribution]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::DimensionContribution

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::DimensionContribution object:

  $service_obj->Method(Att1 => { DimensionName => $value, ..., DimensionValueContributionList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::DimensionContribution object:

  $result = $service_obj->Method(...);
  $result->Att1->DimensionName

=head1 DESCRIPTION

Details about a dimension that contributed to an anomaly.

=head1 ATTRIBUTES


=head2 DimensionName => Str

The name of the dimension.


=head2 DimensionValueContributionList => ArrayRef[L<Paws::LookoutMetrics::DimensionValueContribution>]

A list of dimension values that contributed to the anomaly.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

