# Generated by default/object.tt
package Paws::Macie2::CustomDetection;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has Count => (is => 'ro', isa => 'Int', request_name => 'count', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Occurrences => (is => 'ro', isa => 'Paws::Macie2::Occurrences', request_name => 'occurrences', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::CustomDetection

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::CustomDetection object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Occurrences => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::CustomDetection object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Provides information about a custom data identifier that produced a
sensitive data finding, and the sensitive data that it detected for the
finding.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the custom data identifier.


=head2 Count => Int

The total number of occurrences of the sensitive data that the custom
data identifier detected.


=head2 Name => Str

The name of the custom data identifier.


=head2 Occurrences => L<Paws::Macie2::Occurrences>

The location of 1-15 occurrences of the sensitive data that the custom
data identifier detected. A finding includes location data for a
maximum of 15 occurrences of sensitive data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

