# Generated by default/object.tt
package Paws::Macie2::UsageStatisticsFilter;
  use Moose;
  has Comparator => (is => 'ro', isa => 'Str', request_name => 'comparator', traits => ['NameInRequest']);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has Values => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'values', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::UsageStatisticsFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::UsageStatisticsFilter object:

  $service_obj->Method(Att1 => { Comparator => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::UsageStatisticsFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->Comparator

=head1 DESCRIPTION

Specifies a condition for filtering the results of a query for quota
and usage data for one or more Amazon Macie accounts.

=head1 ATTRIBUTES


=head2 Comparator => Str

The operator to use in the condition. If the value for the key property
is accountId, this value must be CONTAINS. If the value for the key
property is any other supported field, this value can be EQ, GT, GTE,
LT, LTE, or NE.


=head2 Key => Str

The field to use in the condition.


=head2 Values => ArrayRef[Str|Undef]

An array that lists values to use in the condition, based on the value
for the field specified by the key property. If the value for the key
property is accountId, this array can specify multiple values.
Otherwise, this array can specify only one value.

Valid values for each supported field are:

=over

=item *

accountId - The unique identifier for an Amazon Web Services account.

=item *

freeTrialStartDate - The date and time, in UTC and extended ISO 8601
format, when the free trial started for an account.

=item *

serviceLimit - A Boolean (true or false) value that indicates whether
an account has reached its monthly quota.

=item *

total - A string that represents the current estimated cost for an
account.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

