# Generated by default/object.tt
package Paws::Macie2::UserPausedDetails;
  use Moose;
  has JobExpiresAt => (is => 'ro', isa => 'Str', request_name => 'jobExpiresAt', traits => ['NameInRequest']);
  has JobImminentExpirationHealthEventArn => (is => 'ro', isa => 'Str', request_name => 'jobImminentExpirationHealthEventArn', traits => ['NameInRequest']);
  has JobPausedAt => (is => 'ro', isa => 'Str', request_name => 'jobPausedAt', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::UserPausedDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::UserPausedDetails object:

  $service_obj->Method(Att1 => { JobExpiresAt => $value, ..., JobPausedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::UserPausedDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->JobExpiresAt

=head1 DESCRIPTION

Provides information about when a classification job was paused. For a
one-time job, this object also specifies when the job will expire and
be cancelled if it isn't resumed. For a recurring job, this object also
specifies when the paused job run will expire and be cancelled if it
isn't resumed. This object is present only if a job's current status
(jobStatus) is USER_PAUSED. The information in this object applies only
to a job that was paused while it had a status of RUNNING.

=head1 ATTRIBUTES


=head2 JobExpiresAt => Str

The date and time, in UTC and extended ISO 8601 format, when the job or
job run will expire and be cancelled if you don't resume it first.


=head2 JobImminentExpirationHealthEventArn => Str

The Amazon Resource Name (ARN) of the Health event that Amazon Macie
sent to notify you of the job or job run's pending expiration and
cancellation. This value is null if a job has been paused for less than
23 days.


=head2 JobPausedAt => Str

The date and time, in UTC and extended ISO 8601 format, when you paused
the job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

