# Generated by default/object.tt
package Paws::MediaConvert::NexGuardFileMarkerSettings;
  use Moose;
  has License => (is => 'ro', isa => 'Str', request_name => 'license', traits => ['NameInRequest']);
  has Payload => (is => 'ro', isa => 'Int', request_name => 'payload', traits => ['NameInRequest']);
  has Preset => (is => 'ro', isa => 'Str', request_name => 'preset', traits => ['NameInRequest']);
  has Strength => (is => 'ro', isa => 'Str', request_name => 'strength', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::NexGuardFileMarkerSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::NexGuardFileMarkerSettings object:

  $service_obj->Method(Att1 => { License => $value, ..., Strength => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::NexGuardFileMarkerSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->License

=head1 DESCRIPTION

For forensic video watermarking, MediaConvert supports Nagra NexGuard
File Marker watermarking. MediaConvert supports both PreRelease Content
(NGPR/G2) and OTT Streaming workflows.

=head1 ATTRIBUTES


=head2 License => Str

Use the base64 license string that Nagra provides you. Enter it
directly in your JSON job specification or in the console. Required
when you include Nagra NexGuard File Marker watermarking
(NexGuardWatermarkingSettings) in your job.


=head2 Payload => Int

Specify the payload ID that you want associated with this output. Valid
values vary depending on your Nagra NexGuard forensic watermarking
workflow. Required when you include Nagra NexGuard File Marker
watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease
Content (NGPR/G2), specify an integer from 1 through 4,194,303. You
must generate a unique ID for each asset you watermark, and keep a
record of which ID you have assigned to each asset. Neither Nagra nor
MediaConvert keep track of the relationship between output files and
your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks
for each asset. Do this by setting up two output groups. For one output
group, set the value of Payload ID (payload) to 0 in every output. For
the other output group, set Payload ID (payload) to 1 in every output.


=head2 Preset => Str

Enter one of the watermarking preset strings that Nagra provides you.
Required when you include Nagra NexGuard File Marker watermarking
(NexGuardWatermarkingSettings) in your job.


=head2 Strength => Str

Optional. Ignore this setting unless Nagra support directs you to
specify a value. When you don't specify a value here, the Nagra
NexGuard library uses its default value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

