# Generated by default/object.tt
package Paws::Personalize::BatchInferenceJobConfig;
  use Moose;
  has ItemExplorationConfig => (is => 'ro', isa => 'Paws::Personalize::HyperParameters', request_name => 'itemExplorationConfig', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Personalize::BatchInferenceJobConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Personalize::BatchInferenceJobConfig object:

  $service_obj->Method(Att1 => { ItemExplorationConfig => $value, ..., ItemExplorationConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Personalize::BatchInferenceJobConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ItemExplorationConfig

=head1 DESCRIPTION

The configuration details of a batch inference job.

=head1 ATTRIBUTES


=head2 ItemExplorationConfig => L<Paws::Personalize::HyperParameters>

A string to string map specifying the exploration configuration
hyperparameters, including C<explorationWeight> and
C<explorationItemAgeCutOff>, you want to use to configure the amount of
item exploration Amazon Personalize uses when recommending items. See
User-Personalization
(https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Personalize>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

