# Generated by default/object.tt
package Paws::Rekognition::CoversBodyPart;
  use Moose;
  has Confidence => (is => 'ro', isa => 'Num');
  has Value => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Rekognition::CoversBodyPart

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Rekognition::CoversBodyPart object:

  $service_obj->Method(Att1 => { Confidence => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Rekognition::CoversBodyPart object:

  $result = $service_obj->Method(...);
  $result->Att1->Confidence

=head1 DESCRIPTION

Information about an item of Personal Protective Equipment covering a
corresponding body part. For more information, see
DetectProtectiveEquipment.

=head1 ATTRIBUTES


=head2 Confidence => Num

The confidence that Amazon Rekognition has in the value of C<Value>.


=head2 Value => Bool

True if the PPE covers the corresponding body part, otherwise false.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Rekognition>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

