# Generated by default/object.tt
package Paws::Robomaker::Compute;
  use Moose;
  has SimulationUnitLimit => (is => 'ro', isa => 'Int', request_name => 'simulationUnitLimit', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Robomaker::Compute

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Robomaker::Compute object:

  $service_obj->Method(Att1 => { SimulationUnitLimit => $value, ..., SimulationUnitLimit => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Robomaker::Compute object:

  $result = $service_obj->Method(...);
  $result->Att1->SimulationUnitLimit

=head1 DESCRIPTION

Compute information for the simulation job.

=head1 ATTRIBUTES


=head2 SimulationUnitLimit => Int

The simulation unit limit. Your simulation is allocated CPU and memory
proportional to the supplied simulation unit limit. A simulation unit
is 1 vcpu and 2GB of memory. You are only billed for the SU utilization
you consume up to the maximim value provided. The default is 15.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Robomaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

