# Generated by default/object.tt
package Paws::Route53Resolver::ResolverDnssecConfig;
  use Moose;
  has Id => (is => 'ro', isa => 'Str');
  has OwnerId => (is => 'ro', isa => 'Str');
  has ResourceId => (is => 'ro', isa => 'Str');
  has ValidationStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53Resolver::ResolverDnssecConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53Resolver::ResolverDnssecConfig object:

  $service_obj->Method(Att1 => { Id => $value, ..., ValidationStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53Resolver::ResolverDnssecConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

A complex type that contains information about a configuration for
DNSSEC validation.

=head1 ATTRIBUTES


=head2 Id => Str

The ID for a configuration for DNSSEC validation.


=head2 OwnerId => Str

The owner account ID of the virtual private cloud (VPC) for a
configuration for DNSSEC validation.


=head2 ResourceId => Str

The ID of the virtual private cloud (VPC) that you're configuring the
DNSSEC validation status for.


=head2 ValidationStatus => Str

The validation status for a DNSSEC configuration. The status can be one
of the following:

=over

=item *

B<ENABLING:> DNSSEC validation is being enabled but is not complete.

=item *

B<ENABLED:> DNSSEC validation is enabled.

=item *

B<DISABLING:> DNSSEC validation is being disabled but is not complete.

=item *

B<DISABLED> DNSSEC validation is disabled.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53Resolver>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

