# Generated by default/object.tt
package Paws::S3Outposts::Endpoint;
  use Moose;
  has CidrBlock => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has EndpointArn => (is => 'ro', isa => 'Str');
  has NetworkInterfaces => (is => 'ro', isa => 'ArrayRef[Paws::S3Outposts::NetworkInterface]');
  has OutpostsId => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Outposts::Endpoint

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Outposts::Endpoint object:

  $service_obj->Method(Att1 => { CidrBlock => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Outposts::Endpoint object:

  $result = $service_obj->Method(...);
  $result->Att1->CidrBlock

=head1 DESCRIPTION

S3 on Outposts access points simplify managing data access at scale for
shared datasets in Amazon S3 on Outposts. S3 on Outposts uses endpoints
to connect to Outposts buckets so that you can perform actions within
your virtual private cloud (VPC).

=head1 ATTRIBUTES


=head2 CidrBlock => Str

The VPC CIDR committed by this endpoint.


=head2 CreationTime => Str

The time the endpoint was created.


=head2 EndpointArn => Str

The Amazon Resource Name (ARN) of the endpoint.


=head2 NetworkInterfaces => ArrayRef[L<Paws::S3Outposts::NetworkInterface>]

The network interface of the endpoint.


=head2 OutpostsId => Str

The ID of the AWS Outpost.


=head2 Status => Str

The status of the endpoint.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Outposts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

