# Generated by default/object.tt
package Paws::SageMaker::FeatureGroupSummary;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str', required => 1);
  has FeatureGroupArn => (is => 'ro', isa => 'Str', required => 1);
  has FeatureGroupName => (is => 'ro', isa => 'Str', required => 1);
  has FeatureGroupStatus => (is => 'ro', isa => 'Str');
  has OfflineStoreStatus => (is => 'ro', isa => 'Paws::SageMaker::OfflineStoreStatus');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::FeatureGroupSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::FeatureGroupSummary object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., OfflineStoreStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::FeatureGroupSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

The name, Arn, C<CreationTime>, C<FeatureGroup> values,
C<LastUpdatedTime> and C<EnableOnlineStorage> status of a
C<FeatureGroup>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreationTime => Str

A timestamp indicating the time of creation time of the
C<FeatureGroup>.


=head2 B<REQUIRED> FeatureGroupArn => Str

Unique identifier for the C<FeatureGroup>.


=head2 B<REQUIRED> FeatureGroupName => Str

The name of C<FeatureGroup>.


=head2 FeatureGroupStatus => Str

The status of a FeatureGroup. The status can be any of the following:
C<Creating>, C<Created>, C<CreateFail>, C<Deleting> or C<DetailFail>.


=head2 OfflineStoreStatus => L<Paws::SageMaker::OfflineStoreStatus>

Notifies you if replicating data into the C<OfflineStore> has failed.
Returns either: C<Active> or C<Blocked>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

