# Generated by default/object.tt
package Paws::SageMaker::FinalAutoMLJobObjectiveMetric;
  use Moose;
  has MetricName => (is => 'ro', isa => 'Str', required => 1);
  has Type => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Num', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::FinalAutoMLJobObjectiveMetric

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::FinalAutoMLJobObjectiveMetric object:

  $service_obj->Method(Att1 => { MetricName => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::FinalAutoMLJobObjectiveMetric object:

  $result = $service_obj->Method(...);
  $result->Att1->MetricName

=head1 DESCRIPTION

The best candidate result from an AutoML training job.

=head1 ATTRIBUTES


=head2 B<REQUIRED> MetricName => Str

The name of the metric with the best result. For a description of the
possible objective metrics, see AutoMLJobObjective$MetricName.


=head2 Type => Str

The type of metric with the best result.


=head2 B<REQUIRED> Value => Num

The value of the metric with the best result.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

