# Generated by default/object.tt
package Paws::SageMaker::ModelPackageGroup;
  use Moose;
  has CreatedBy => (is => 'ro', isa => 'Paws::SageMaker::UserContext');
  has CreationTime => (is => 'ro', isa => 'Str');
  has ModelPackageGroupArn => (is => 'ro', isa => 'Str');
  has ModelPackageGroupDescription => (is => 'ro', isa => 'Str');
  has ModelPackageGroupName => (is => 'ro', isa => 'Str');
  has ModelPackageGroupStatus => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::Tag]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ModelPackageGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ModelPackageGroup object:

  $service_obj->Method(Att1 => { CreatedBy => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ModelPackageGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedBy

=head1 DESCRIPTION

A group of versioned models in the model registry.

=head1 ATTRIBUTES


=head2 CreatedBy => L<Paws::SageMaker::UserContext>




=head2 CreationTime => Str

The time that the model group was created.


=head2 ModelPackageGroupArn => Str

The Amazon Resource Name (ARN) of the model group.


=head2 ModelPackageGroupDescription => Str

The description for the model group.


=head2 ModelPackageGroupName => Str

The name of the model group.


=head2 ModelPackageGroupStatus => Str

The status of the model group. This can be one of the following values.

=over

=item *

C<PENDING> - The model group is pending being created.

=item *

C<IN_PROGRESS> - The model group is in the process of being created.

=item *

C<COMPLETED> - The model group was successfully created.

=item *

C<FAILED> - The model group failed.

=item *

C<DELETING> - The model group is in the process of being deleted.

=item *

C<DELETE_FAILED> - SageMaker failed to delete the model group.

=back



=head2 Tags => ArrayRef[L<Paws::SageMaker::Tag>]

A list of the tags associated with the model group. For more
information, see Tagging Amazon Web Services resources
(https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the
I<Amazon Web Services General Reference Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

