# Generated by default/object.tt
package Paws::SageMaker::ModelQualityJobInput;
  use Moose;
  has EndpointInput => (is => 'ro', isa => 'Paws::SageMaker::EndpointInput', required => 1);
  has GroundTruthS3Input => (is => 'ro', isa => 'Paws::SageMaker::MonitoringGroundTruthS3Input', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ModelQualityJobInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ModelQualityJobInput object:

  $service_obj->Method(Att1 => { EndpointInput => $value, ..., GroundTruthS3Input => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ModelQualityJobInput object:

  $result = $service_obj->Method(...);
  $result->Att1->EndpointInput

=head1 DESCRIPTION

The input for the model quality monitoring job. Currently endponts are
supported for input for model quality monitoring jobs.

=head1 ATTRIBUTES


=head2 B<REQUIRED> EndpointInput => L<Paws::SageMaker::EndpointInput>




=head2 B<REQUIRED> GroundTruthS3Input => L<Paws::SageMaker::MonitoringGroundTruthS3Input>

The ground truth label provided for the model.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

