# Generated by default/object.tt
package Paws::SecurityHub::SensitiveDataResult;
  use Moose;
  has Category => (is => 'ro', isa => 'Str');
  has Detections => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::SensitiveDataDetections]');
  has TotalCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::SensitiveDataResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::SensitiveDataResult object:

  $service_obj->Method(Att1 => { Category => $value, ..., TotalCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::SensitiveDataResult object:

  $result = $service_obj->Method(...);
  $result->Att1->Category

=head1 DESCRIPTION

Contains a detected instance of sensitive data that are based on
built-in identifiers.

=head1 ATTRIBUTES


=head2 Category => Str

The category of sensitive data that was detected. For example, the
category can indicate that the sensitive data involved credentials,
financial information, or personal information.


=head2 Detections => ArrayRef[L<Paws::SecurityHub::SensitiveDataDetections>]

The list of detected instances of sensitive data.


=head2 TotalCount => Int

The total number of occurrences of sensitive data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

