# Generated by default/object.tt
package Paws::Transfer::HomeDirectoryMapEntry;
  use Moose;
  has Entry => (is => 'ro', isa => 'Str', required => 1);
  has Target => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transfer::HomeDirectoryMapEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transfer::HomeDirectoryMapEntry object:

  $service_obj->Method(Att1 => { Entry => $value, ..., Target => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transfer::HomeDirectoryMapEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->Entry

=head1 DESCRIPTION

Represents an object that contains entries and targets for
C<HomeDirectoryMappings>.

The following is an C<Entry> and C<Target> pair example for C<chroot>.

C<[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]>

If the target of a logical directory entry does not exist in Amazon S3
or EFS, the entry is ignored. As a workaround, you can use the Amazon
S3 API or EFS API to create 0 byte objects as place holders for your
directory. If using the CLI, use the C<s3api> or C<efsapi> call instead
of C<s3> or C<efs> so you can use the put-object operation. For
example, you use the following: C<aws s3api put-object --bucket
bucketname --key path/to/folder/>. Make sure that the end of the key
name ends in a C</> for it to be considered a folder.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Entry => Str

Represents an entry for C<HomeDirectoryMappings>.


=head2 B<REQUIRED> Target => Str

Represents the map target that is used in a C<HomeDirectorymapEntry>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transfer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

