# Generated by default/object.tt
package Paws::WorkMailMessageFlow::S3Reference;
  use Moose;
  has Bucket => (is => 'ro', isa => 'Str', request_name => 'bucket', traits => ['NameInRequest'], required => 1);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest'], required => 1);
  has ObjectVersion => (is => 'ro', isa => 'Str', request_name => 'objectVersion', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WorkMailMessageFlow::S3Reference

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WorkMailMessageFlow::S3Reference object:

  $service_obj->Method(Att1 => { Bucket => $value, ..., ObjectVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WorkMailMessageFlow::S3Reference object:

  $result = $service_obj->Method(...);
  $result->Att1->Bucket

=head1 DESCRIPTION

Amazon S3 object representing the updated message content, in MIME
format.

The region for the S3 bucket containing the S3 object must match the
region used for WorkMail operations. Also, for WorkMail to process an
S3 object, it must have permission to access that object. For more
information, see Updating message content with AWS Lambda
(https://docs.aws.amazon.com/workmail/latest/adminguide/update-with-lambda.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> Bucket => Str

The S3 bucket name.


=head2 B<REQUIRED> Key => Str

The S3 key object name.


=head2 ObjectVersion => Str

If you enable versioning for the bucket, you can specify the object
version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WorkMailMessageFlow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

