
BEGIN {
    if ($ENV{PERL_CORE}) {
	chdir('t') if -d 't';
	@INC = $^O eq 'MacOS' ? qw(::lib) : qw(../lib);
    }
}

use strict;
use warnings;
BEGIN { $| = 1; print "1..26\n"; }
my $count = 0;
sub ok ($;$) {
    my $p = my $r = shift;
    if (@_) {
	my $x = shift;
	$p = !defined $x ? !defined $r : !defined $r ? 0 : $r eq $x;
    }
    print $p ? "ok" : "not ok", ' ', ++$count, "\n";
}

use Unicode::Collate;

ok(1);

sub _pack_U   { Unicode::Collate::pack_U(@_) }
sub _unpack_U { Unicode::Collate::unpack_U(@_) }

#########################

use Unicode::Collate::CJK::Zhuyin;

my $collator = Unicode::Collate->new(
    table => undef,
    normalization => undef,
    overrideCJK => \&Unicode::Collate::CJK::Zhuyin::weightZhuyin
);

sub hex_sort {
    my @source = map _pack_U(hex $_), split ' ', shift;
    my @sorted = $collator->sort(@source);
    return join " ", map sprintf("%04X", _unpack_U($_)), @sorted;
}

# 1

$collator->change(level => 1);

ok($collator->lt("\x{516B}", "\x{628A}"));
ok($collator->lt("\x{628A}", "\x{5DF4}"));
ok($collator->lt("\x{5DF4}", "\x{767D}"));
ok($collator->lt("\x{767D}", "\x{5317}"));
ok($collator->lt("\x{5317}", "\x{9F3B}"));
ok($collator->lt("\x{9F3B}", "\x{4E0D}"));
ok($collator->lt("\x{4E0D}", "\x{547D}"));
ok($collator->lt("\x{547D}", "\x{6BCD}"));
ok($collator->lt("\x{6BCD}", "\x{6253}"));
ok($collator->lt("\x{6253}", "\x{7530}"));
ok($collator->lt("\x{7530}", "\x{52AA}"));
ok($collator->lt("\x{52AA}", "\x{529B}"));
ok($collator->lt("\x{529B}", "\x{5375}"));
ok($collator->lt("\x{5375}", "\x{5149}"));
ok($collator->lt("\x{5149}", "\x{5915}"));
ok($collator->lt("\x{5915}", "\x{4E09}"));
ok($collator->lt("\x{4E09}", "\x{4E00}"));
ok($collator->lt("\x{4E00}", "\x{7528}"));

# Ext.B
ok($collator->lt("\x{20000}", "\x{20001}"));
ok($collator->lt("\x{20001}", "\x{20002}"));
ok($collator->lt("\x{20002}", "\x{20003}"));
ok($collator->lt("\x{20003}", "\x{20004}"));
ok($collator->lt("\x{20004}", "\x{20005}"));

# 24

ok(hex_sort('4E00 4E8C 4E09 56DB 4E94 516D 4E03 516B 4E5D 5341'),
            '516B 516D 4E5D 4E03 5341 56DB 4E09 4E8C 4E00 4E94');



ok(hex_sort('4E0C 4E8D 4F5C 5140 554A 5750 57C3 5EA7 963F 9F3D 9F3E 9F44'),
            '9F3E 4E0C 9F3D 9F44 4E8D 4F5C 5750 5EA7 963F 554A 57C3 5140');

# 26
