package Net::Async::Github::User;

use strict;
use warnings;

our $VERSION = '0.009'; # VERSION

use parent qw(Net::Async::Github::Common);

=head1 NAME

Net::Async::Github::User

=head1 DESCRIPTION

Autogenerated module.

=cut

use URI::Template ();
use Time::Moment ();
use Net::Async::Github::Plan ();

=head1 METHODS

=cut

=head2 login

Provides an accessor for C<login>.

=cut

sub login {
    shift->{login}
}

=head2 id

Provides an accessor for C<id>.

=cut

sub id {
    shift->{id}
}

=head2 avatar_url

Provides an accessor for C<avatar_url>.

=cut

sub avatar_url {
    $_[0]->{avatar_url} =
     URI::Template->new($_[0]->{avatar_url})
        unless ref $_[0]->{avatar_url};
    shift->{avatar_url}
}

=head2 gravatar_id

Provides an accessor for C<gravatar_id>.

=cut

sub gravatar_id {
    shift->{gravatar_id}
}

=head2 url

Provides an accessor for C<url>.

=cut

sub url {
    shift->{url}
}

=head2 html_url

Provides an accessor for C<html_url>.

=cut

sub html_url {
    $_[0]->{html_url} =
     URI::Template->new($_[0]->{html_url})
        unless ref $_[0]->{html_url};
    shift->{html_url}
}

=head2 followers_url

Provides an accessor for C<followers_url>.

=cut

sub followers_url {
    $_[0]->{followers_url} =
     URI::Template->new($_[0]->{followers_url})
        unless ref $_[0]->{followers_url};
    shift->{followers_url}
}

=head2 following_url

Provides an accessor for C<following_url>.

=cut

sub following_url {
    $_[0]->{following_url} =
     URI::Template->new($_[0]->{following_url})
        unless ref $_[0]->{following_url};
    shift->{following_url}
}

=head2 gists_url

Provides an accessor for C<gists_url>.

=cut

sub gists_url {
    $_[0]->{gists_url} =
     URI::Template->new($_[0]->{gists_url})
        unless ref $_[0]->{gists_url};
    shift->{gists_url}
}

=head2 starred_url

Provides an accessor for C<starred_url>.

=cut

sub starred_url {
    $_[0]->{starred_url} =
     URI::Template->new($_[0]->{starred_url})
        unless ref $_[0]->{starred_url};
    shift->{starred_url}
}

=head2 subscriptions_url

Provides an accessor for C<subscriptions_url>.

=cut

sub subscriptions_url {
    $_[0]->{subscriptions_url} =
     URI::Template->new($_[0]->{subscriptions_url})
        unless ref $_[0]->{subscriptions_url};
    shift->{subscriptions_url}
}

=head2 organizations_url

Provides an accessor for C<organizations_url>.

=cut

sub organizations_url {
    $_[0]->{organizations_url} =
     URI::Template->new($_[0]->{organizations_url})
        unless ref $_[0]->{organizations_url};
    shift->{organizations_url}
}

=head2 repos_url

Provides an accessor for C<repos_url>.

=cut

sub repos_url {
    $_[0]->{repos_url} =
     URI::Template->new($_[0]->{repos_url})
        unless ref $_[0]->{repos_url};
    shift->{repos_url}
}

=head2 events_url

Provides an accessor for C<events_url>.

=cut

sub events_url {
    $_[0]->{events_url} =
     URI::Template->new($_[0]->{events_url})
        unless ref $_[0]->{events_url};
    shift->{events_url}
}

=head2 received_events_url

Provides an accessor for C<received_events_url>.

=cut

sub received_events_url {
    $_[0]->{received_events_url} =
     URI::Template->new($_[0]->{received_events_url})
        unless ref $_[0]->{received_events_url};
    shift->{received_events_url}
}

=head2 type

Provides an accessor for C<type>.

=cut

sub type {
    shift->{type}
}

=head2 site_admin

Provides an accessor for C<site_admin>.

=cut

sub site_admin {
    shift->{site_admin}
    ? 1 : 0
}

=head2 name

Provides an accessor for C<name>.

=cut

sub name {
    shift->{name}
}

=head2 company

Provides an accessor for C<company>.

=cut

sub company {
    shift->{company}
}

=head2 blog

Provides an accessor for C<blog>.

=cut

sub blog {
    shift->{blog}
}

=head2 location

Provides an accessor for C<location>.

=cut

sub location {
    shift->{location}
}

=head2 email

Provides an accessor for C<email>.

=cut

sub email {
    shift->{email}
}

=head2 hireable

Provides an accessor for C<hireable>.

=cut

sub hireable {
    shift->{hireable}
    ? 1 : 0
}

=head2 bio

Provides an accessor for C<bio>.

=cut

sub bio {
    shift->{bio}
}

=head2 public_repos

Provides an accessor for C<public_repos>.

=cut

sub public_repos {
    shift->{public_repos}
}

=head2 public_gists

Provides an accessor for C<public_gists>.

=cut

sub public_gists {
    shift->{public_gists}
}

=head2 followers

Provides an accessor for C<followers>.

=cut

sub followers {
    shift->{followers}
}

=head2 following

Provides an accessor for C<following>.

=cut

sub following {
    shift->{following}
}

=head2 created_at

Provides an accessor for C<created_at>.

=cut

sub created_at {
    $_[0]->{created_at} =
    (defined($_[0]->{created_at}) && length($_[0]->{created_at}) ? Time::Moment->from_string($_[0]->{created_at}) : undef)
        unless ref $_[0]->{created_at};
    shift->{created_at}
}

=head2 updated_at

Provides an accessor for C<updated_at>.

=cut

sub updated_at {
    $_[0]->{updated_at} =
    (defined($_[0]->{updated_at}) && length($_[0]->{updated_at}) ? Time::Moment->from_string($_[0]->{updated_at}) : undef)
        unless ref $_[0]->{updated_at};
    shift->{updated_at}
}

=head2 total_private_repos

Provides an accessor for C<total_private_repos>.

=cut

sub total_private_repos {
    shift->{total_private_repos}
}

=head2 owned_private_repos

Provides an accessor for C<owned_private_repos>.

=cut

sub owned_private_repos {
    shift->{owned_private_repos}
}

=head2 private_gists

Provides an accessor for C<private_gists>.

=cut

sub private_gists {
    shift->{private_gists}
}

=head2 disk_usage

Provides an accessor for C<disk_usage>.

=cut

sub disk_usage {
    shift->{disk_usage}
}

=head2 collaborators

Provides an accessor for C<collaborators>.

=cut

sub collaborators {
    shift->{collaborators}
}

=head2 plan

Provides an accessor for C<plan>.

=cut

sub plan {
    $_[0]->{plan} =
     Net::Async::Github::Plan->new($_[0]->{plan})
        unless ref $_[0]->{plan};
    shift->{plan}
}

1;

