/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.net.PortProber;

public class BaseServerOptions {
    private final Config config;
    private int port = -1;

    public BaseServerOptions(Config config) {
        this.config = config;
    }

    public Optional<String> getHostname() {
        return this.config.get("server", "hostname");
    }

    public int getPort() {
        if (this.port != -1) {
            return this.port;
        }
        int port = this.config.getInt("server", "port").orElseGet(PortProber::findFreePort);
        if (port < 0) {
            throw new ConfigException("Port cannot be less than 0: " + port, new Object[0]);
        }
        this.port = port;
        return port;
    }

    public int getMaxServerThreads() {
        int count = this.config.getInt("server", "max-threads").orElse(200);
        if (count < 0) {
            throw new ConfigException("Maximum number of server threads cannot be less than 0: " + count, new Object[0]);
        }
        return count;
    }

    public URI getExternalUri() {
        String host = this.getHostname().orElseGet(() -> new NetworkUtils().getNonLoopbackAddressOfThisMachine());
        int port = this.getPort();
        try {
            return new URI("http", null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Cannot determine external URI: " + e.getMessage(), new Object[0]);
        }
    }
}

