/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlImage
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlImage.class);
    public static final String TAG_NAME = "img";
    public static final String TAG_NAME2 = "image";
    private final String originalQualifiedName_;
    private int lastClickX_;
    private int lastClickY_;
    private WebResponse imageWebResponse_;
    private transient ImageData imageData_;
    private int width_;
    private int height_;
    private boolean downloaded_;
    private boolean onloadInvoked_;
    private boolean createdByJavascript_;

    HtmlImage(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        block3: {
            super(HtmlImage.unifyLocalName(qualifiedName), page, attributes);
            this.width_ = -1;
            this.height_ = -1;
            this.originalQualifiedName_ = qualifiedName;
            if (page.getWebClient().getOptions().isDownloadImages()) {
                try {
                    this.downloadImageIfNeeded();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Unable to download image for element " + this);
                }
            }
        }
    }

    private static String unifyLocalName(String qualifiedName) {
        if (qualifiedName != null && qualifiedName.endsWith(TAG_NAME2)) {
            int pos = qualifiedName.lastIndexOf(TAG_NAME2);
            return qualifiedName.substring(0, pos) + TAG_NAME;
        }
        return qualifiedName;
    }

    @Override
    protected void onAddedToPage() {
        this.doOnLoad();
        super.onAddedToPage();
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String value, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String oldValue;
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if ("src".equals(qualifiedName) && value != ATTRIBUTE_NOT_DEFINED && htmlPage != null && !(oldValue = this.getAttributeNS(namespaceURI, qualifiedName)).equals(value)) {
            String readyState;
            super.setAttributeNS(namespaceURI, qualifiedName, value, notifyAttributeChangeListeners, notifyMutationObservers);
            this.onloadInvoked_ = false;
            this.downloaded_ = false;
            this.width_ = -1;
            this.height_ = -1;
            if (this.imageData_ != null) {
                this.imageData_.close();
                this.imageData_ = null;
            }
            if ("loading".equals(readyState = htmlPage.getReadyState())) {
                PostponedAction action = new PostponedAction(this.getPage()){

                    @Override
                    public void execute() throws Exception {
                        HtmlImage.this.doOnLoad();
                    }
                };
                htmlPage.addAfterLoadAction(action);
                return;
            }
            this.doOnLoad();
            return;
        }
        super.setAttributeNS(namespaceURI, qualifiedName, value, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    public void doOnLoad() {
        if (this.onloadInvoked_) {
            return;
        }
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if (htmlPage == null) {
            return;
        }
        WebClient client = htmlPage.getWebClient();
        if (!client.getOptions().isJavaScriptEnabled()) {
            this.onloadInvoked_ = true;
            return;
        }
        if (this.hasEventHandlers("onload") && !this.getSrcAttribute().isEmpty()) {
            boolean ok;
            this.onloadInvoked_ = true;
            try {
                this.downloadImageIfNeeded();
                int i = this.imageWebResponse_.getStatusCode();
                ok = i >= 200 && i < 300 || i == 305;
            }
            catch (IOException e) {
                ok = false;
            }
            if (ok) {
                final Event event = new Event(this, "load");
                final Node scriptObject = (Node)this.getScriptableObject();
                String readyState = htmlPage.getReadyState();
                if ("loading".equals(readyState)) {
                    PostponedAction action = new PostponedAction(this.getPage()){

                        @Override
                        public void execute() throws Exception {
                            scriptObject.executeEventLocally(event);
                        }
                    };
                    htmlPage.addAfterLoadAction(action);
                } else {
                    scriptObject.executeEventLocally(event);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to download image for " + this + "; not firing onload event.");
            }
        }
    }

    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public final String getAltAttribute() {
        return this.getAttribute("alt");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getLongDescAttribute() {
        return this.getAttribute("longdesc");
    }

    public final String getHeightAttribute() {
        return this.getAttribute("height");
    }

    public final String getWidthAttribute() {
        return this.getAttribute("width");
    }

    public final String getUseMapAttribute() {
        return this.getAttribute("usemap");
    }

    public final String getIsmapAttribute() {
        return this.getAttribute("ismap");
    }

    public final String getAlignAttribute() {
        return this.getAttribute("align");
    }

    public final String getBorderAttribute() {
        return this.getAttribute("border");
    }

    public final String getHspaceAttribute() {
        return this.getAttribute("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttribute("vspace");
    }

    public int getHeight() throws IOException {
        if (this.height_ < 0) {
            this.determineWidthAndHeight();
        }
        return this.height_;
    }

    public int getWidth() throws IOException {
        if (this.width_ < 0) {
            this.determineWidthAndHeight();
        }
        return this.width_;
    }

    public ImageReader getImageReader() throws IOException {
        this.readImageIfNeeded();
        return this.imageData_.getImageReader();
    }

    private void determineWidthAndHeight() throws IOException {
        ImageReader imgReader = this.getImageReader();
        this.width_ = imgReader.getWidth(0);
        this.height_ = imgReader.getHeight(0);
        if (this.imageData_ != null) {
            this.imageData_.close();
            this.imageData_ = null;
        }
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        if (downloadIfNeeded) {
            this.downloadImageIfNeeded();
        }
        return this.imageWebResponse_;
    }

    private void downloadImageIfNeeded() throws IOException {
        if (!this.downloaded_) {
            String src = this.getSrcAttribute();
            if (!("".equals(src) || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY) && StringUtils.isBlank(src))) {
                HtmlPage page = (HtmlPage)this.getPage();
                WebClient webclient = page.getWebClient();
                URL url = page.getFullyQualifiedUrl(src);
                String accept = webclient.getBrowserVersion().getImgAcceptHeader();
                WebRequest request = new WebRequest(url, accept);
                request.setAdditionalHeader("Referer", page.getUrl().toExternalForm());
                this.imageWebResponse_ = webclient.loadWebResponse(request);
            }
            if (this.imageData_ != null) {
                this.imageData_.close();
                this.imageData_ = null;
            }
            this.downloaded_ = this.hasFeature(BrowserVersionFeatures.JS_IMAGE_COMPLETE_RETURNS_TRUE_FOR_NO_REQUEST) || this.imageWebResponse_ != null && this.imageWebResponse_.getContentType().contains(TAG_NAME2);
            this.width_ = -1;
            this.height_ = -1;
        }
    }

    private void readImageIfNeeded() throws IOException {
        this.downloadImageIfNeeded();
        if (this.imageData_ == null) {
            if (null == this.imageWebResponse_) {
                throw new IOException("No image response available (src=" + this.getSrcAttribute() + ")");
            }
            ImageInputStream iis = ImageIO.createImageInputStream(this.imageWebResponse_.getContentAsStream());
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                iis.close();
                throw new IOException("No image detected in response");
            }
            ImageReader imageReader = iter.next();
            imageReader.setInput(iis);
            this.imageData_ = new ImageData(imageReader);
            while (iter.hasNext()) {
                iter.next().dispose();
            }
        }
    }

    public Page click(int x, int y) throws IOException {
        this.lastClickX_ = x;
        this.lastClickY_ = y;
        return super.click();
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlAnchor anchor;
        if (this.getUseMapAttribute() != ATTRIBUTE_NOT_DEFINED) {
            String mapName = this.getUseMapAttribute().substring(1);
            HtmlElement doc = ((HtmlPage)this.getPage()).getDocumentElement();
            HtmlMap map = (HtmlMap)doc.getOneHtmlElementByAttribute("map", "name", mapName);
            for (DomElement element : map.getChildElements()) {
                HtmlArea area;
                if (!(element instanceof HtmlArea) || !(area = (HtmlArea)element).containsPoint(this.lastClickX_, this.lastClickY_)) continue;
                area.doClickStateUpdate(shiftKey, ctrlKey);
                return false;
            }
        }
        if ((anchor = (HtmlAnchor)this.getEnclosingElement("a")) == null) {
            return false;
        }
        if (this.getIsmapAttribute() != ATTRIBUTE_NOT_DEFINED) {
            String suffix = "?" + this.lastClickX_ + "," + this.lastClickY_;
            anchor.doClickStateUpdate(false, false, suffix);
            return false;
        }
        anchor.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    public void saveAs(File file) throws IOException {
        this.downloadImageIfNeeded();
        if (null != this.imageWebResponse_) {
            try (InputStream inputStream = this.imageWebResponse_.getContentAsStream();
                 FileOutputStream fileOut = new FileOutputStream(file);){
                IOUtils.copy(this.imageWebResponse_.getContentAsStream(), (OutputStream)fileOut);
            }
        }
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    public boolean isComplete() {
        return this.downloaded_ || (this.hasFeature(BrowserVersionFeatures.JS_IMAGE_COMPLETE_RETURNS_TRUE_FOR_NO_REQUEST) ? ATTRIBUTE_NOT_DEFINED == this.getSrcAttribute() : this.imageData_ != null);
    }

    @Deprecated
    public boolean getComplete() {
        return this.isComplete();
    }

    @Override
    public boolean isDisplayed() {
        String src = this.getSrcAttribute();
        if (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_INVISIBLE_NO_SRC) && (ATTRIBUTE_NOT_DEFINED == src || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY) && StringUtils.isBlank(src) || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_EMPTY_SRC_DISPLAY_FALSE) && StringUtils.isEmpty(src))) {
            return false;
        }
        return super.isDisplayed();
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }

    public String getOriginalQualifiedName() {
        return this.originalQualifiedName_;
    }

    @Override
    public String getLocalName() {
        if (this.wasCreatedByJavascript() && (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLELEMENT) || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLUNKNOWNELEMENT))) {
            return this.originalQualifiedName_;
        }
        return super.getLocalName();
    }

    static final class ImageData
    implements AutoCloseable {
        private final ImageReader imageReader_;

        ImageData(ImageReader imageReader) {
            this.imageReader_ = imageReader;
        }

        public ImageReader getImageReader() {
            return this.imageReader_;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.imageReader_ != null) {
                try {
                    ImageInputStream stream = (ImageInputStream)this.imageReader_.getInput();
                    Throwable throwable = null;
                    if (stream != null) {
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), e);
                }
                finally {
                    this.imageReader_.setInput(null);
                    this.imageReader_.dispose();
                }
            }
        }
    }
}

