/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DocumentType;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHeadElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHtmlElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTitleElement;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class DOMImplementation
extends SimpleScriptable {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public DOMImplementation() {
    }

    @JsxFunction
    public boolean hasFeature(String feature, String version) {
        switch (feature) {
            case "Core": 
            case "HTML": 
            case "XHTML": 
            case "XML": {
                switch (version) {
                    case "1.0": 
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CORE_3);
                    }
                }
                break;
            }
            case "Views": {
                switch (version) {
                    case "1.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_VIEWS_1);
                    }
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_VIEWS_3);
                    }
                }
                break;
            }
            case "StyleSheets": {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_STYLESHEETS);
            }
            case "CSS": {
                switch (version) {
                    case "1.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS_1);
                    }
                    case "2.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS_2);
                    }
                    case "3.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS_3);
                    }
                }
                break;
            }
            case "CSS2": {
                switch (version) {
                    case "1.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS2_1);
                    }
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS2_3);
                    }
                }
                break;
            }
            case "CSS3": {
                switch (version) {
                    case "1.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS3_1);
                    }
                    case "2.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS3_2);
                    }
                    case "3.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS3_3);
                    }
                }
                break;
            }
            case "Events": 
            case "HTMLEvents": 
            case "MouseEvents": 
            case "MutationEvents": {
                switch (version) {
                    case "1.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_EVENTS_1);
                    }
                    case "2.0": 
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "UIEvents": {
                switch (version) {
                    case "1.0": 
                    case "2.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_UIEVENTS_2);
                    }
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "KeyboardEvents": {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_KEYBOARDEVENTS);
            }
            case "MutationNameEvents": {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_MUTATIONNAMEEVENTS);
            }
            case "TextEvents": {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_TEXTEVENTS);
            }
            case "LS": 
            case "LS-Async": {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_LS);
            }
            case "Range": 
            case "Traversal": {
                switch (version) {
                    case "1.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_RANGE_1);
                    }
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_RANGE_3);
                    }
                }
                break;
            }
            case "Validation": {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_VALIDATION);
            }
            case "XPath": {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_XPATH);
            }
            case "http://www.w3.org/TR/SVG11/feature#BasicStructure": 
            case "http://www.w3.org/TR/SVG11/feature#Shape": {
                switch (version) {
                    case "1.0": 
                    case "1.1": {
                        return true;
                    }
                    case "1.2": {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_SVG_BASICSTRUCTURE_1_2);
                    }
                }
                break;
            }
        }
        return false;
    }

    @JsxFunction
    public XMLDocument createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) {
        XMLDocument document = new XMLDocument(this.getWindow().getWebWindow());
        document.setParentScope(this.getParentScope());
        document.setPrototype(this.getPrototype(document.getClass()));
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            XmlPage page = (XmlPage)document.getDomNodeOrDie();
            page.appendChild(page.createElementNS("".equals(namespaceURI) ? null : namespaceURI, qualifiedName));
        }
        return document;
    }

    @JsxFunction
    public HTMLDocument createHTMLDocument(Object titleObj) {
        if (titleObj == Undefined.instance && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_CREATE_HTMLDOCOMENT_REQUIRES_TITLE)) {
            throw Context.reportRuntimeError("Title is required");
        }
        HTMLDocument document = new HTMLDocument();
        document.setParentScope(this.getParentScope());
        document.setPrototype(this.getPrototype(document.getClass()));
        StringWebResponse resp = new StringWebResponse("", WebClient.URL_ABOUT_BLANK);
        HtmlPage page = new HtmlPage(resp, this.getWindow().getWebWindow());
        page.setEnclosingWindow(null);
        document.setDomNode(page);
        HTMLHtmlElement html = (HTMLHtmlElement)document.createElement("html");
        page.appendChild(html.getDomNodeOrDie());
        HTMLHeadElement head = (HTMLHeadElement)document.createElement("head");
        html.appendChild(head);
        if (titleObj != Undefined.instance) {
            HTMLTitleElement title = (HTMLTitleElement)document.createElement("title");
            head.appendChild(title);
            title.setTextContent(Context.toString(titleObj));
        }
        HTMLBodyElement body = (HTMLBodyElement)document.createElement("body");
        html.appendChild(body);
        return document;
    }
}

