/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import com.google.common.collect.Iterables;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkInterface {
    private final String name;
    private java.net.NetworkInterface networkInterface;
    private final Iterable<InetAddress> inetAddresses;
    private Boolean isLoopback;

    public NetworkInterface(java.net.NetworkInterface networkInterface) {
        this(networkInterface.getName(), Collections.list(networkInterface.getInetAddresses()));
        this.networkInterface = networkInterface;
    }

    NetworkInterface(String name, Iterable<InetAddress> inetAddresses) {
        this.name = name;
        this.inetAddresses = Iterables.unmodifiableIterable(inetAddresses);
    }

    NetworkInterface(String name, InetAddress ... inetAddresses) {
        this(name, Arrays.asList(inetAddresses));
        this.isLoopback = this.isLoopBackFromINetAddresses(this.inetAddresses);
    }

    public boolean isIp4AddressBindingOnly() {
        return this.getIp6Address() == null;
    }

    public boolean isLoopBack() {
        if (this.isLoopback == null) {
            if (this.networkInterface != null) {
                try {
                    this.isLoopback = this.networkInterface.isLoopback();
                }
                catch (SocketException ex) {
                    Logger.getLogger(NetworkInterface.class.getName()).log(Level.WARNING, null, ex);
                }
            }
            if (this.isLoopback == null) {
                this.isLoopback = this.isLoopBackFromINetAddresses(Collections.list(this.networkInterface.getInetAddresses()));
            }
        }
        return this.isLoopback;
    }

    private boolean isLoopBackFromINetAddresses(Iterable<InetAddress> inetAddresses) {
        Iterator<InetAddress> iterator = inetAddresses.iterator();
        return iterator.hasNext() && iterator.next().isLoopbackAddress();
    }

    public InetAddress getIp4LoopbackOnly() {
        if (!this.isLoopBack()) {
            return null;
        }
        InetAddress lastFound = null;
        for (InetAddress inetAddress : this.inetAddresses) {
            if (!inetAddress.isLoopbackAddress() || NetworkInterface.isIpv6(inetAddress)) continue;
            lastFound = inetAddress;
        }
        return lastFound;
    }

    static boolean isIpv6(InetAddress address) {
        return address instanceof Inet6Address;
    }

    public InetAddress getIp4NonLoopBackOnly() {
        for (InetAddress inetAddress : this.inetAddresses) {
            if (inetAddress.isLoopbackAddress() || NetworkInterface.isIpv6(inetAddress)) continue;
            return inetAddress;
        }
        return null;
    }

    public InetAddress getIp6Address() {
        for (InetAddress inetAddress : this.inetAddresses) {
            if (!NetworkInterface.isIpv6(inetAddress)) continue;
            return inetAddress;
        }
        return null;
    }

    public Iterable<InetAddress> getInetAddresses() {
        return this.inetAddresses;
    }

    public String getName() {
        return this.name;
    }
}

