/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.CommandHandler;

public class GetAllSessions
implements CommandHandler {
    private final ActiveSessions allSessions;
    private final BeanToJsonConverter toJson;

    public GetAllSessions(ActiveSessions allSessions, BeanToJsonConverter toJson) {
        this.allSessions = Objects.requireNonNull(allSessions);
        this.toJson = Objects.requireNonNull(toJson);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        ArrayList value = new ArrayList();
        this.allSessions.getAllSessions().forEach(s -> value.add(ImmutableMap.of("id", s.getId().toString(), "capabilities", s.getCapabilities())));
        ImmutableMap payloadObj = ImmutableMap.of("status", 0, "value", value);
        byte[] payload = this.toJson.convert(payloadObj).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(200);
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(payload.length));
        resp.setContent(payload);
    }
}

