/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.SessionTerminationReason;
import org.openqa.grid.internal.TestSession;
import org.openqa.selenium.remote.server.jmx.JMXHelper;

@ThreadSafe
public class ActiveTestSessions {
    private static final Logger log = Logger.getLogger(ActiveTestSessions.class.getName());
    private final Set<TestSession> activeTestSessions = new CopyOnWriteArraySet<TestSession>();
    private final Queue<ExternalSessionKey> terminatedSessions = new ConcurrentLinkedQueue<ExternalSessionKey>();
    private final Map<ExternalSessionKey, SessionTerminationReason> reasons = new ConcurrentHashMap<ExternalSessionKey, SessionTerminationReason>();

    public boolean add(TestSession testSession) {
        boolean added = this.activeTestSessions.add(testSession);
        if (!added) {
            log.severe("Error adding session : " + testSession);
        }
        new JMXHelper().register(testSession);
        return added;
    }

    public boolean remove(TestSession o, SessionTerminationReason reason) {
        this.updateReason(o, reason);
        try {
            new JMXHelper().unregister(o.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return this.activeTestSessions.remove(o);
    }

    private void updateReason(TestSession o, SessionTerminationReason reason) {
        if (o.getExternalKey() == null) {
            if (SessionTerminationReason.CREATIONFAILED != reason) {
                log.info("Removed a session that had not yet assigned an external key " + o.getInternalKey() + ", indicates failure in session creation " + (Object)((Object)reason));
            }
            return;
        }
        this.terminatedSessions.add(o.getExternalKey());
        this.reasons.put(o.getExternalKey(), reason);
        if (this.reasons.size() > 1000) {
            ExternalSessionKey remove = this.terminatedSessions.remove();
            this.reasons.remove(remove);
        }
    }

    public TestSession findSessionByInternalKey(String internalKey) {
        if (internalKey == null) {
            return null;
        }
        for (TestSession session : this.activeTestSessions) {
            if (!internalKey.equals(session.getInternalKey())) continue;
            return session;
        }
        return null;
    }

    public TestSession getExistingSession(ExternalSessionKey externalkey) {
        TestSession sessionByExternalKey = this.findSessionByExternalKey(externalkey);
        if (sessionByExternalKey == null) {
            String keyId;
            SessionTerminationReason sessionTerminationReason = externalkey != null ? this.reasons.get(externalkey) : null;
            String string = keyId = externalkey != null ? externalkey.getKey() : "(null externalkey)";
            if (sessionTerminationReason != null) {
                String msg = "Session [" + keyId + "] was terminated due to " + (Object)((Object)sessionTerminationReason);
                log.fine(msg);
                throw new GridException(msg);
            }
            String msg = "Session [" + keyId + "] not available and is not among the last 1000 terminated sessions.\nActive sessions are" + this.unmodifiableSet();
            log.fine(msg);
            throw new GridException(msg);
        }
        return sessionByExternalKey;
    }

    public TestSession findSessionByExternalKey(ExternalSessionKey externalkey) {
        if (externalkey == null) {
            return null;
        }
        for (TestSession session : this.activeTestSessions) {
            if (!externalkey.equals(session.getExternalKey())) continue;
            return session;
        }
        return null;
    }

    public Set<TestSession> unmodifiableSet() {
        return Collections.unmodifiableSet(this.activeTestSessions);
    }
}

