/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.remote.ExecuteMethod;

public class RemoteKeyboard
implements Keyboard {
    protected final ExecuteMethod executor;

    public RemoteKeyboard(ExecuteMethod executor) {
        this.executor = executor;
    }

    @Override
    public void sendKeys(CharSequence ... keysToSend) {
        if (keysToSend == null) {
            throw new IllegalArgumentException("Keys to send should be a not null CharSequence");
        }
        this.executor.execute("sendKeysToActiveElement", ImmutableMap.of("value", keysToSend));
    }

    @Override
    public void pressKey(CharSequence keyToPress) {
        CharSequence[] sequence = new CharSequence[]{keyToPress};
        this.executor.execute("sendKeysToActiveElement", ImmutableMap.of("value", sequence));
    }

    @Override
    public void releaseKey(CharSequence keyToRelease) {
        CharSequence[] sequence = new CharSequence[]{keyToRelease};
        this.executor.execute("sendKeysToActiveElement", ImmutableMap.of("value", sequence));
    }
}

