/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.openqa.selenium.support.ui.LoadableComponent;

public abstract class SlowLoadableComponent<T extends LoadableComponent<T>>
extends LoadableComponent<T> {
    private final Clock clock;
    private final Duration timeOutInSeconds;

    public SlowLoadableComponent(Clock clock, int timeOutInSeconds) {
        this.clock = clock;
        this.timeOutInSeconds = Duration.ofSeconds(timeOutInSeconds);
    }

    @Override
    public T get() {
        try {
            this.isLoaded();
            return (T)this;
        }
        catch (Error e) {
            this.load();
            Instant end = this.clock.instant().plus(this.timeOutInSeconds);
            while (this.clock.instant().isBefore(end)) {
                try {
                    this.isLoaded();
                    return (T)this;
                }
                catch (Error error) {
                    this.isError();
                    this.waitFor();
                }
            }
            this.isLoaded();
            return (T)this;
        }
    }

    protected void isError() throws Error {
    }

    protected long sleepFor() {
        return 200L;
    }

    private void waitFor() {
        try {
            Thread.sleep(this.sleepFor());
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

