/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic;

import edu.stanford.nlp.international.arabic.pipeline.DefaultLexicalMapper;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.trees.international.arabic.ATBTreeUtils;
import edu.stanford.nlp.util.Function;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMArabicEscaper
implements Function<List<HasWord>, List<HasWord>> {
    private static final Pattern pEnt = Pattern.compile("\\$[a-z]+_\\((.*?)\\)");
    private boolean warnedEntityEscaping = false;
    private boolean warnedProcliticEnclitic = false;
    private final DefaultLexicalMapper lexMapper;
    private final boolean annotationsAndClassingOnly;

    public IBMArabicEscaper() {
        this(false);
    }

    public IBMArabicEscaper(boolean annoteAndClassOnly) {
        this.annotationsAndClassingOnly = annoteAndClassOnly;
        this.lexMapper = new DefaultLexicalMapper();
    }

    public void disableWarnings() {
        this.warnedEntityEscaping = true;
        this.warnedProcliticEnclitic = true;
    }

    private String escapeString(String word) {
        String firstStage = this.stripAnnotationsAndClassing(word);
        String secondStage = ATBTreeUtils.escape(firstStage);
        if (secondStage.length() == 0) {
            return firstStage;
        }
        if (!firstStage.equals(secondStage)) {
            return secondStage;
        }
        String thirdStage = this.lexMapper.map(null, secondStage);
        if (thirdStage.length() == 0) {
            return secondStage;
        }
        return thirdStage;
    }

    private String stripAnnotationsAndClassing(String word) {
        String w = word;
        int wLen = w.length();
        if (wLen > 1) {
            Matcher m2 = pEnt.matcher(w);
            if (m2.matches()) {
                if (!this.warnedEntityEscaping) {
                    System.err.printf("%s: Removing IBM MT-style classing: %s --> %s\n", this.getClass().getName(), m2.group(0), m2.group(1));
                    this.warnedEntityEscaping = true;
                }
                w = m2.replaceAll("$1");
            } else if (w.charAt(0) == '+') {
                if (!this.warnedProcliticEnclitic) {
                    this.warnedProcliticEnclitic = true;
                    System.err.printf("%s: Removing IBM MT-style proclitic/enclitic indicators\n", this.getClass().getName());
                }
                w = w.substring(1);
            } else if (w.charAt(wLen - 1) == '#') {
                if (!this.warnedProcliticEnclitic) {
                    this.warnedProcliticEnclitic = true;
                    System.err.printf("%s: Removing IBM MT-style proclitic/enclitic indicators\n", this.getClass().getName());
                }
                w = w.substring(0, wLen - 1);
            }
        }
        if (w.length() == 0) {
            return word;
        }
        return w;
    }

    @Override
    public List<HasWord> apply(List<HasWord> sentence) {
        ArrayList<HasWord> newSentence = new ArrayList<HasWord>(sentence);
        for (HasWord wd : newSentence) {
            wd.setWord(this.apply(wd.word()));
        }
        return newSentence;
    }

    @Override
    public String apply(String w) {
        String escapedWord;
        String string = escapedWord = this.annotationsAndClassingOnly ? this.stripAnnotationsAndClassing(w) : this.escapeString(w);
        if (escapedWord.equals("")) {
            throw new RuntimeException(String.format("Word (%s) mapped to null", w));
        }
        return escapedWord.intern();
    }

    public static void main(String[] args) throws IOException {
        IBMArabicEscaper escaper = new IBMArabicEscaper();
        boolean printToStdout = false;
        for (String arg : args) {
            String line;
            PrintWriter pw;
            if ("-f".equals(arg)) {
                printToStdout = true;
                continue;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(arg), "UTF-8"));
            if (printToStdout) {
                pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8")));
            } else {
                String outFile = arg + ".sent";
                pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8")));
            }
            while ((line = br.readLine()) != null) {
                String[] words = line.split("\\s+");
                for (int i = 0; i < words.length; ++i) {
                    String w = escaper.escapeString(words[i]);
                    pw.print(w);
                    if (i == words.length - 1) continue;
                    pw.print(" ");
                }
                pw.println();
            }
            br.close();
            pw.close();
        }
    }
}

