package WebService::MinFraud::Data::Rx::Type::CCToken;

use 5.010;

use strict;
use warnings;
use namespace::autoclean;

our $VERSION = '1.010000';

use parent 'Data::Rx::CommonType::EasyNew';

use List::Util qw( all );
use Role::Tiny::With;

with 'WebService::MinFraud::Role::Data::Rx::Type';

sub assert_valid {
    my ( $self, $value ) = @_;

    return 1
        if $value
        && ( length($value) < 256 )
        && ( $value !~ m/^[0-9]{1,19}$/ )
        && ( $value =~ m/^[\x21-\x7E]+$/ );

    $self->fail(
        {
            error => [qw(type)],
            message =>
                'Found value is not considered a valid credit card token.',
            value => $value,
        }
    );
}

sub type_uri {
    ## no critic(ValuesAndExpressions::ProhibitCommaSeparatedStatements)
    'tag:maxmind.com,MAXMIND:rx/cctoken';
}

1;

# ABSTRACT: A type to check for what MaxMind considers a valid credit card token

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::MinFraud::Data::Rx::Type::CCToken - A type to check for what MaxMind considers a valid credit card token

=head1 VERSION

version 1.010000

=head1 SUPPORT

Bugs may be submitted through L<https://github.com/maxmind/minfraud-api-perl/issues>.

=head1 AUTHOR

Mateu Hunter <mhunter@maxmind.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 - 2020 by MaxMind, Inc.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
