use strict;
use warnings;
use Test::More;
use HTML::DateSelector;
BEGIN {
    eval q[use Test::Base];
    plan skip_all => "Test::Base required for testing base" if $@;
}

plan tests => 1 * blocks;

filters(
    {
    input => [qw/eval/],
    expected => [qw/chomp/],
    }
);

run {
    my $block = shift;

    is($block->input, $block->expected, $block->name);
}

__END__

=== ymd
--- input
HTML::DateSelector->ymd('end_on', {start_year => 2005, end_year => 2009})
--- expected
<select name="end_on_year" id="end_on_year">
<option value="2005">2005</option>
<option value="2006">2006</option>
<option value="2007">2007</option>
<option value="2008">2008</option>
<option value="2009">2009</option>
</select>

<select name="end_on_month" id="end_on_month">
<option value="1">1</option>
<option value="2">2</option>
<option value="3">3</option>
<option value="4">4</option>
<option value="5">5</option>
<option value="6">6</option>
<option value="7">7</option>
<option value="8">8</option>
<option value="9">9</option>
<option value="10">10</option>
<option value="11">11</option>
<option value="12">12</option>
</select>

<select name="end_on_day" id="end_on_day">
<option value="1">1</option>
<option value="2">2</option>
<option value="3">3</option>
<option value="4">4</option>
<option value="5">5</option>
<option value="6">6</option>
<option value="7">7</option>
<option value="8">8</option>
<option value="9">9</option>
<option value="10">10</option>
<option value="11">11</option>
<option value="12">12</option>
<option value="13">13</option>
<option value="14">14</option>
<option value="15">15</option>
<option value="16">16</option>
<option value="17">17</option>
<option value="18">18</option>
<option value="19">19</option>
<option value="20">20</option>
<option value="21">21</option>
<option value="22">22</option>
<option value="23">23</option>
<option value="24">24</option>
<option value="25">25</option>
<option value="26">26</option>
<option value="27">27</option>
<option value="28">28</option>
<option value="29">29</option>
<option value="30">30</option>
<option value="31">31</option>
</select>

=== ym
--- input
HTML::DateSelector->ym('end_on', {start_year => 2005, end_year => 2009})
--- expected
<select name="end_on_year" id="end_on_year">
<option value="2005">2005</option>
<option value="2006">2006</option>
<option value="2007">2007</option>
<option value="2008">2008</option>
<option value="2009">2009</option>
</select>

<select name="end_on_month" id="end_on_month">
<option value="1">1</option>
<option value="2">2</option>
<option value="3">3</option>
<option value="4">4</option>
<option value="5">5</option>
<option value="6">6</option>
<option value="7">7</option>
<option value="8">8</option>
<option value="9">9</option>
<option value="10">10</option>
<option value="11">11</option>
<option value="12">12</option>
</select>
