#!/usr/bin/perl -w

my @ciphers =
(
	'Blowfish',
	'Blowfish_PP',
	'Camellia',
	'Camellia_PP',
	'CAST5',
	'CAST5_PP',
	'DES',
	'DES_PP',
	'IDEA',
	'Rijndael',
	'Rijndael_PP',
	'Twofish',
	'Twofish2',
	'XTEA',
	'XTEA_PP',
);

my @padstyles = qw(standard zeroes oneandzeroes rijndael_compat space null);

use Test::More;

BEGIN { use_ok (Crypt::ECB) }

my $text = "123456780";
my $key  = "This is an at least 56 Byte long test key!!! It really is.";

my $ecb = Crypt::ECB->new;

foreach my $cipher (@ciphers)
{
	eval { $ecb->cipher($cipher) };

	SKIP: {	skip "$cipher not installed", 1*@padstyles if $@;

		my $ks = $ecb->keysize || 56;
		$ecb->key( substr($key, 0, $ks) );

		my $bs = $ecb->blocksize;
		my $text = "x" x $bs . "0";

		foreach my $padstyle (@padstyles)
		{
			$ecb->padding($padstyle);

			my $enc = $ecb->encrypt($text);
			ok($ecb->decrypt($enc) eq $text, "$cipher, $padstyle padding: en- and decrypting '$text'");
		}
	}
}

done_testing( @ciphers * @padstyles + 1 );
