/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ResultSetFactory;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;

public class GenericExecutionContext
extends ContextImpl
implements ExecutionContext {
    private ResultSet sourceRS;
    protected ResultSetFactory rsFactory;
    protected ResultSetStatisticsFactory rssFactory;
    protected ExecutionFactory execFactory;

    public ResultSetFactory getResultSetFactory() {
        if (this.rsFactory == null) {
            this.rsFactory = this.execFactory.getResultSetFactory();
        }
        return this.rsFactory;
    }

    public ResultSetStatisticsFactory getResultSetStatisticsFactory() throws StandardException {
        if (this.rssFactory == null) {
            this.rssFactory = (ResultSetStatisticsFactory)Monitor.bootServiceModule(false, this.execFactory, "org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory", null);
        }
        return this.rssFactory;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.execFactory;
    }

    public void beginStatement(ResultSet resultSet) throws StandardException {
        this.sourceRS = resultSet;
    }

    public void endStatement() throws StandardException {
        this.sourceRS = null;
    }

    public Object[] siftForeignKeys(Object[] objectArray) throws StandardException {
        return objectArray;
    }

    public Object siftTriggers(Object object) throws StandardException {
        return object;
    }

    public void cleanupOnError(Throwable throwable) throws StandardException {
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            if (standardException.getSeverity() > 20000) {
                return;
            }
            if (this.sourceRS != null) {
                this.sourceRS.close();
                this.sourceRS = null;
            }
            this.endStatement();
            return;
        }
    }

    public GenericExecutionContext(ResultSetFactory resultSetFactory, ContextManager contextManager, ExecutionFactory executionFactory) {
        super(contextManager, "ExecutionContext");
        this.rsFactory = resultSetFactory;
        this.execFactory = executionFactory;
    }
}

