/* This is based on RFC3530 */

/*
 * NFS v4 Definitions
 */


/*
 *  Copyright (C) The Internet Society (1998,1999,2000,2001,2002).
 *  All Rights Reserved.
 */

/*
 *      nfs4_prot.x
 *
 */
/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "libnfs-zdr.h"
#include "libnfs-raw-nfs4.h"

uint32_t
zdr_nfs_ftype4 (ZDR *zdrs, nfs_ftype4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfsstat4 (ZDR *zdrs, nfsstat4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_bitmap4 (ZDR *zdrs, bitmap4 *objp)
{
	

	 if (!zdr_array (zdrs, (char **)&objp->bitmap4_val, (u_int *) &objp->bitmap4_len, ~0,
		sizeof (uint32_t), (zdrproc_t) zdr_uint32_t))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_offset4 (ZDR *zdrs, offset4 *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_count4 (ZDR *zdrs, count4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_length4 (ZDR *zdrs, length4 *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_clientid4 (ZDR *zdrs, clientid4 *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_sequenceid4 (ZDR *zdrs, sequenceid4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_seqid4 (ZDR *zdrs, seqid4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_slotid4 (ZDR *zdrs, slotid4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_utf8string (ZDR *zdrs, utf8string *objp)
{
	

	 if (!zdr_bytes (zdrs, (char **)&objp->utf8string_val, (u_int *) &objp->utf8string_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_utf8str_cis (ZDR *zdrs, utf8str_cis *objp)
{
	

	 if (!zdr_utf8string (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_utf8str_cs (ZDR *zdrs, utf8str_cs *objp)
{
	

	 if (!zdr_utf8string (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_utf8str_mixed (ZDR *zdrs, utf8str_mixed *objp)
{
	

	 if (!zdr_utf8string (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_component4 (ZDR *zdrs, component4 *objp)
{
	

	 if (!zdr_utf8str_cs (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_pathname4 (ZDR *zdrs, pathname4 *objp)
{
	

	 if (!zdr_array (zdrs, (char **)&objp->pathname4_val, (u_int *) &objp->pathname4_len, ~0,
		sizeof (component4), (zdrproc_t) zdr_component4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_lockid4 (ZDR *zdrs, nfs_lockid4 *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_cookie4 (ZDR *zdrs, nfs_cookie4 *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_linktext4 (ZDR *zdrs, linktext4 *objp)
{
	

	 if (!zdr_utf8str_cs (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_sec_oid4 (ZDR *zdrs, sec_oid4 *objp)
{
	

	 if (!zdr_bytes (zdrs, (char **)&objp->sec_oid4_val, (u_int *) &objp->sec_oid4_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_qop4 (ZDR *zdrs, qop4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_mode4 (ZDR *zdrs, mode4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_changeid4 (ZDR *zdrs, changeid4 *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_verifier4 (ZDR *zdrs, verifier4 objp)
{
	

	 if (!zdr_opaque (zdrs, objp, NFS4_VERIFIER_SIZE))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_sessionid4 (ZDR *zdrs, sessionid4 objp)
{
	

	 if (!zdr_opaque (zdrs, objp, NFS4_SESSIONID_SIZE))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_authsys_parms (ZDR *zdrs, authsys_parms *objp)
{
	

	 if (!zdr_u_int (zdrs, &objp->stamp))
		 return FALSE;
	 if (!zdr_string (zdrs, &objp->machinename, 255))
		 return FALSE;
	 if (!zdr_u_int (zdrs, &objp->uid))
		 return FALSE;
	 if (!zdr_u_int (zdrs, &objp->gid))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->gids.gids_val, (u_int *) &objp->gids.gids_len, 16,
		sizeof (u_int), (zdrproc_t) zdr_u_int))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_deviceid4 (ZDR *zdrs, deviceid4 objp)
{
	

	 if (!zdr_opaque (zdrs, objp, NFS4_DEVICEID4_SIZE))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_layouttype4 (ZDR *zdrs, layouttype4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_layoutupdate4 (ZDR *zdrs, layoutupdate4 *objp)
{
	

	 if (!zdr_layouttype4 (zdrs, &objp->lou_type))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->lou_body.lou_body_val, (u_int *) &objp->lou_body.lou_body_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_device_addr4 (ZDR *zdrs, device_addr4 *objp)
{
	

	 if (!zdr_layouttype4 (zdrs, &objp->da_layout_type))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->da_addr_body.da_addr_body_val, (u_int *) &objp->da_addr_body.da_addr_body_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfstime4 (ZDR *zdrs, nfstime4 *objp)
{
	

	 if (!zdr_int64_t (zdrs, &objp->seconds))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->nseconds))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_time_how4 (ZDR *zdrs, time_how4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_layoutiomode4 (ZDR *zdrs, layoutiomode4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_layout_content4 (ZDR *zdrs, layout_content4 *objp)
{
	

	 if (!zdr_layouttype4 (zdrs, &objp->loc_type))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->loc_body.loc_body_val, (u_int *) &objp->loc_body.loc_body_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_layout4 (ZDR *zdrs, layout4 *objp)
{
	

	 if (!zdr_offset4 (zdrs, &objp->lo_offset))
		 return FALSE;
	 if (!zdr_length4 (zdrs, &objp->lo_length))
		 return FALSE;
	 if (!zdr_layoutiomode4 (zdrs, &objp->lo_iomode))
		 return FALSE;
	 if (!zdr_layout_content4 (zdrs, &objp->lo_content))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_settime4 (ZDR *zdrs, settime4 *objp)
{
	

	 if (!zdr_time_how4 (zdrs, &objp->set_it))
		 return FALSE;
	switch (objp->set_it) {
	case SET_TO_CLIENT_TIME4:
		 if (!zdr_nfstime4 (zdrs, &objp->settime4_u.time))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_nfs_fh4 (ZDR *zdrs, nfs_fh4 *objp)
{
	

	 if (!zdr_bytes (zdrs, (char **)&objp->nfs_fh4_val, (u_int *) &objp->nfs_fh4_len, NFS4_FHSIZE))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fsid4 (ZDR *zdrs, fsid4 *objp)
{
	

	 if (!zdr_uint64_t (zdrs, &objp->major))
		 return FALSE;
	 if (!zdr_uint64_t (zdrs, &objp->minor))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fs_location4 (ZDR *zdrs, fs_location4 *objp)
{
	

	 if (!zdr_array (zdrs, (char **)&objp->server.server_val, (u_int *) &objp->server.server_len, ~0,
		sizeof (utf8str_cis), (zdrproc_t) zdr_utf8str_cis))
		 return FALSE;
	 if (!zdr_pathname4 (zdrs, &objp->rootpath))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fs_locations4 (ZDR *zdrs, fs_locations4 *objp)
{
	

	 if (!zdr_pathname4 (zdrs, &objp->fs_root))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->locations.locations_val, (u_int *) &objp->locations.locations_len, ~0,
		sizeof (fs_location4), (zdrproc_t) zdr_fs_location4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_acetype4 (ZDR *zdrs, acetype4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_aceflag4 (ZDR *zdrs, aceflag4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_acemask4 (ZDR *zdrs, acemask4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfsace4 (ZDR *zdrs, nfsace4 *objp)
{
	

	 if (!zdr_acetype4 (zdrs, &objp->type))
		 return FALSE;
	 if (!zdr_aceflag4 (zdrs, &objp->flag))
		 return FALSE;
	 if (!zdr_acemask4 (zdrs, &objp->access_mask))
		 return FALSE;
	 if (!zdr_utf8str_mixed (zdrs, &objp->who))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_specdata4 (ZDR *zdrs, specdata4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, &objp->specdata1))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->specdata2))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_supported_attrs (ZDR *zdrs, fattr4_supported_attrs *objp)
{
	

	 if (!zdr_bitmap4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_type (ZDR *zdrs, fattr4_type *objp)
{
	

	 if (!zdr_nfs_ftype4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_fh_expire_type (ZDR *zdrs, fattr4_fh_expire_type *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_change (ZDR *zdrs, fattr4_change *objp)
{
	

	 if (!zdr_changeid4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_size (ZDR *zdrs, fattr4_size *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_link_support (ZDR *zdrs, fattr4_link_support *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_symlink_support (ZDR *zdrs, fattr4_symlink_support *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_named_attr (ZDR *zdrs, fattr4_named_attr *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_fsid (ZDR *zdrs, fattr4_fsid *objp)
{
	

	 if (!zdr_fsid4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_unique_handles (ZDR *zdrs, fattr4_unique_handles *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_lease_time (ZDR *zdrs, fattr4_lease_time *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_rdattr_error (ZDR *zdrs, fattr4_rdattr_error *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_acl (ZDR *zdrs, fattr4_acl *objp)
{
	

	 if (!zdr_array (zdrs, (char **)&objp->fattr4_acl_val, (u_int *) &objp->fattr4_acl_len, ~0,
		sizeof (nfsace4), (zdrproc_t) zdr_nfsace4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_aclsupport (ZDR *zdrs, fattr4_aclsupport *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_archive (ZDR *zdrs, fattr4_archive *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_cansettime (ZDR *zdrs, fattr4_cansettime *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_case_insensitive (ZDR *zdrs, fattr4_case_insensitive *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_case_preserving (ZDR *zdrs, fattr4_case_preserving *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_chown_restricted (ZDR *zdrs, fattr4_chown_restricted *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_fileid (ZDR *zdrs, fattr4_fileid *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_files_avail (ZDR *zdrs, fattr4_files_avail *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_filehandle (ZDR *zdrs, fattr4_filehandle *objp)
{
	

	 if (!zdr_nfs_fh4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_files_free (ZDR *zdrs, fattr4_files_free *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_files_total (ZDR *zdrs, fattr4_files_total *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_fs_locations (ZDR *zdrs, fattr4_fs_locations *objp)
{
	

	 if (!zdr_fs_locations4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_hidden (ZDR *zdrs, fattr4_hidden *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_homogeneous (ZDR *zdrs, fattr4_homogeneous *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_maxfilesize (ZDR *zdrs, fattr4_maxfilesize *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_maxlink (ZDR *zdrs, fattr4_maxlink *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_maxname (ZDR *zdrs, fattr4_maxname *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_maxread (ZDR *zdrs, fattr4_maxread *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_maxwrite (ZDR *zdrs, fattr4_maxwrite *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_mimetype (ZDR *zdrs, fattr4_mimetype *objp)
{
	

	 if (!zdr_utf8str_cs (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_mode (ZDR *zdrs, fattr4_mode *objp)
{
	

	 if (!zdr_mode4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_mounted_on_fileid (ZDR *zdrs, fattr4_mounted_on_fileid *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_no_trunc (ZDR *zdrs, fattr4_no_trunc *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_numlinks (ZDR *zdrs, fattr4_numlinks *objp)
{
	

	 if (!zdr_uint32_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_owner (ZDR *zdrs, fattr4_owner *objp)
{
	

	 if (!zdr_utf8str_mixed (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_owner_group (ZDR *zdrs, fattr4_owner_group *objp)
{
	

	 if (!zdr_utf8str_mixed (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_quota_avail_hard (ZDR *zdrs, fattr4_quota_avail_hard *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_quota_avail_soft (ZDR *zdrs, fattr4_quota_avail_soft *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_quota_used (ZDR *zdrs, fattr4_quota_used *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_rawdev (ZDR *zdrs, fattr4_rawdev *objp)
{
	

	 if (!zdr_specdata4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_space_avail (ZDR *zdrs, fattr4_space_avail *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_space_free (ZDR *zdrs, fattr4_space_free *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_space_total (ZDR *zdrs, fattr4_space_total *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_space_used (ZDR *zdrs, fattr4_space_used *objp)
{
	

	 if (!zdr_uint64_t (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_system (ZDR *zdrs, fattr4_system *objp)
{
	

	 if (!zdr_bool (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_time_access (ZDR *zdrs, fattr4_time_access *objp)
{
	

	 if (!zdr_nfstime4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_time_access_set (ZDR *zdrs, fattr4_time_access_set *objp)
{
	

	 if (!zdr_settime4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_time_backup (ZDR *zdrs, fattr4_time_backup *objp)
{
	

	 if (!zdr_nfstime4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_time_create (ZDR *zdrs, fattr4_time_create *objp)
{
	

	 if (!zdr_nfstime4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_time_delta (ZDR *zdrs, fattr4_time_delta *objp)
{
	

	 if (!zdr_nfstime4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_time_metadata (ZDR *zdrs, fattr4_time_metadata *objp)
{
	

	 if (!zdr_nfstime4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_time_modify (ZDR *zdrs, fattr4_time_modify *objp)
{
	

	 if (!zdr_nfstime4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4_time_modify_set (ZDR *zdrs, fattr4_time_modify_set *objp)
{
	

	 if (!zdr_settime4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_attrlist4 (ZDR *zdrs, attrlist4 *objp)
{
	

	 if (!zdr_bytes (zdrs, (char **)&objp->attrlist4_val, (u_int *) &objp->attrlist4_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_fattr4 (ZDR *zdrs, fattr4 *objp)
{
	

	 if (!zdr_bitmap4 (zdrs, &objp->attrmask))
		 return FALSE;
	 if (!zdr_attrlist4 (zdrs, &objp->attr_vals))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_change_info4 (ZDR *zdrs, change_info4 *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->atomic))
		 return FALSE;
	 if (!zdr_changeid4 (zdrs, &objp->before))
		 return FALSE;
	 if (!zdr_changeid4 (zdrs, &objp->after))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_clientaddr4 (ZDR *zdrs, clientaddr4 *objp)
{
	

	 if (!zdr_string (zdrs, &objp->r_netid, ~0))
		 return FALSE;
	 if (!zdr_string (zdrs, &objp->r_addr, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_cb_client4 (ZDR *zdrs, cb_client4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, &objp->cb_program))
		 return FALSE;
	 if (!zdr_clientaddr4 (zdrs, &objp->cb_location))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_stateid4 (ZDR *zdrs, stateid4 *objp)
{
	

	
	 if (!zdr_uint32_t (zdrs, &objp->seqid))
		 return FALSE;
	 if (!zdr_opaque (zdrs, objp->other, 12))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_client_id4 (ZDR *zdrs, nfs_client_id4 *objp)
{
	

	 if (!zdr_verifier4 (zdrs, objp->verifier))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->id.id_val, (u_int *) &objp->id.id_len, NFS4_OPAQUE_LIMIT))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_open_owner4 (ZDR *zdrs, open_owner4 *objp)
{
	

	 if (!zdr_clientid4 (zdrs, &objp->clientid))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->owner.owner_val, (u_int *) &objp->owner.owner_len, NFS4_OPAQUE_LIMIT))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_lock_owner4 (ZDR *zdrs, lock_owner4 *objp)
{
	

	 if (!zdr_clientid4 (zdrs, &objp->clientid))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->owner.owner_val, (u_int *) &objp->owner.owner_len, NFS4_OPAQUE_LIMIT))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_lock_type4 (ZDR *zdrs, nfs_lock_type4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_client_owner4 (ZDR *zdrs, client_owner4 *objp)
{
	

	 if (!zdr_verifier4 (zdrs, objp->co_verifier))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->co_ownerid.co_ownerid_val, (u_int *) &objp->co_ownerid.co_ownerid_len, NFS4_OPAQUE_LIMIT))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_server_owner4 (ZDR *zdrs, server_owner4 *objp)
{
	

	 if (!zdr_uint64_t (zdrs, &objp->so_minor_id))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->so_major_id.so_major_id_val, (u_int *) &objp->so_major_id.so_major_id_len, NFS4_OPAQUE_LIMIT))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_impl_id4 (ZDR *zdrs, nfs_impl_id4 *objp)
{
	

	 if (!zdr_utf8str_cis (zdrs, &objp->nii_domain))
		 return FALSE;
	 if (!zdr_utf8str_cs (zdrs, &objp->nii_name))
		 return FALSE;
	 if (!zdr_nfstime4 (zdrs, &objp->nii_date))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_ACCESS4args (ZDR *zdrs, ACCESS4args *objp)
{
	

	 if (!zdr_uint32_t (zdrs, &objp->access))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_ACCESS4resok (ZDR *zdrs, ACCESS4resok *objp)
{
	

	 if (!zdr_uint32_t (zdrs, &objp->supported))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->access))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_ACCESS4res (ZDR *zdrs, ACCESS4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_ACCESS4resok (zdrs, &objp->ACCESS4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_CLOSE4args (ZDR *zdrs, CLOSE4args *objp)
{
	

	 if (!zdr_seqid4 (zdrs, &objp->seqid))
		 return FALSE;
	 if (!zdr_stateid4 (zdrs, &objp->open_stateid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CLOSE4res (ZDR *zdrs, CLOSE4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_stateid4 (zdrs, &objp->CLOSE4res_u.open_stateid))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_COMMIT4args (ZDR *zdrs, COMMIT4args *objp)
{
	

	 if (!zdr_offset4 (zdrs, &objp->offset))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->count))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_COMMIT4resok (ZDR *zdrs, COMMIT4resok *objp)
{
	

	 if (!zdr_verifier4 (zdrs, objp->writeverf))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_COMMIT4res (ZDR *zdrs, COMMIT4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_COMMIT4resok (zdrs, &objp->COMMIT4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_createtype4 (ZDR *zdrs, createtype4 *objp)
{
	

	 if (!zdr_nfs_ftype4 (zdrs, &objp->type))
		 return FALSE;
	switch (objp->type) {
	case NF4LNK:
		 if (!zdr_linktext4 (zdrs, &objp->createtype4_u.linkdata))
			 return FALSE;
		break;
	case NF4BLK:
	case NF4CHR:
		 if (!zdr_specdata4 (zdrs, &objp->createtype4_u.devdata))
			 return FALSE;
		break;
	case NF4SOCK:
	case NF4FIFO:
	case NF4DIR:
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_CREATE4args (ZDR *zdrs, CREATE4args *objp)
{
	

	 if (!zdr_createtype4 (zdrs, &objp->objtype))
		 return FALSE;
	 if (!zdr_component4 (zdrs, &objp->objname))
		 return FALSE;
	 if (!zdr_fattr4 (zdrs, &objp->createattrs))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CREATE4resok (ZDR *zdrs, CREATE4resok *objp)
{
	

	 if (!zdr_change_info4 (zdrs, &objp->cinfo))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->attrset))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CREATE4res (ZDR *zdrs, CREATE4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_CREATE4resok (zdrs, &objp->CREATE4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_DELEGPURGE4args (ZDR *zdrs, DELEGPURGE4args *objp)
{
	

	 if (!zdr_clientid4 (zdrs, &objp->clientid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_DELEGPURGE4res (ZDR *zdrs, DELEGPURGE4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_DELEGRETURN4args (ZDR *zdrs, DELEGRETURN4args *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->deleg_stateid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_DELEGRETURN4res (ZDR *zdrs, DELEGRETURN4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETATTR4args (ZDR *zdrs, GETATTR4args *objp)
{
	

	 if (!zdr_bitmap4 (zdrs, &objp->attr_request))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETATTR4resok (ZDR *zdrs, GETATTR4resok *objp)
{
	

	 if (!zdr_fattr4 (zdrs, &objp->obj_attributes))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETATTR4res (ZDR *zdrs, GETATTR4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_GETATTR4resok (zdrs, &objp->GETATTR4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_GETFH4resok (ZDR *zdrs, GETFH4resok *objp)
{
	

	 if (!zdr_nfs_fh4 (zdrs, &objp->object))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETFH4res (ZDR *zdrs, GETFH4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_GETFH4resok (zdrs, &objp->GETFH4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_LINK4args (ZDR *zdrs, LINK4args *objp)
{
	

	 if (!zdr_component4 (zdrs, &objp->newname))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LINK4resok (ZDR *zdrs, LINK4resok *objp)
{
	

	 if (!zdr_change_info4 (zdrs, &objp->cinfo))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LINK4res (ZDR *zdrs, LINK4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_LINK4resok (zdrs, &objp->LINK4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_open_to_lock_owner4 (ZDR *zdrs, open_to_lock_owner4 *objp)
{
	

	 if (!zdr_seqid4 (zdrs, &objp->open_seqid))
		 return FALSE;
	 if (!zdr_stateid4 (zdrs, &objp->open_stateid))
		 return FALSE;
	 if (!zdr_seqid4 (zdrs, &objp->lock_seqid))
		 return FALSE;
	 if (!zdr_lock_owner4 (zdrs, &objp->lock_owner))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_exist_lock_owner4 (ZDR *zdrs, exist_lock_owner4 *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->lock_stateid))
		 return FALSE;
	 if (!zdr_seqid4 (zdrs, &objp->lock_seqid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_locker4 (ZDR *zdrs, locker4 *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->new_lock_owner))
		 return FALSE;
	switch (objp->new_lock_owner) {
	case TRUE:
		 if (!zdr_open_to_lock_owner4 (zdrs, &objp->locker4_u.open_owner))
			 return FALSE;
		break;
	case FALSE:
		 if (!zdr_exist_lock_owner4 (zdrs, &objp->locker4_u.lock_owner))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_LOCK4args (ZDR *zdrs, LOCK4args *objp)
{
	

	 if (!zdr_nfs_lock_type4 (zdrs, &objp->locktype))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->reclaim))
		 return FALSE;
	 if (!zdr_offset4 (zdrs, &objp->offset))
		 return FALSE;
	 if (!zdr_length4 (zdrs, &objp->length))
		 return FALSE;
	 if (!zdr_locker4 (zdrs, &objp->locker))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LOCK4denied (ZDR *zdrs, LOCK4denied *objp)
{
	

	 if (!zdr_offset4 (zdrs, &objp->offset))
		 return FALSE;
	 if (!zdr_length4 (zdrs, &objp->length))
		 return FALSE;
	 if (!zdr_nfs_lock_type4 (zdrs, &objp->locktype))
		 return FALSE;
	 if (!zdr_lock_owner4 (zdrs, &objp->owner))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LOCK4resok (ZDR *zdrs, LOCK4resok *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->lock_stateid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LOCK4res (ZDR *zdrs, LOCK4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_LOCK4resok (zdrs, &objp->LOCK4res_u.resok4))
			 return FALSE;
		break;
	case NFS4ERR_DENIED:
		 if (!zdr_LOCK4denied (zdrs, &objp->LOCK4res_u.denied))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_LOCKT4args (ZDR *zdrs, LOCKT4args *objp)
{
	

	 if (!zdr_nfs_lock_type4 (zdrs, &objp->locktype))
		 return FALSE;
	 if (!zdr_offset4 (zdrs, &objp->offset))
		 return FALSE;
	 if (!zdr_length4 (zdrs, &objp->length))
		 return FALSE;
	 if (!zdr_lock_owner4 (zdrs, &objp->owner))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LOCKT4res (ZDR *zdrs, LOCKT4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4ERR_DENIED:
		 if (!zdr_LOCK4denied (zdrs, &objp->LOCKT4res_u.denied))
			 return FALSE;
		break;
	case NFS4_OK:
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_LOCKU4args (ZDR *zdrs, LOCKU4args *objp)
{
	

	 if (!zdr_nfs_lock_type4 (zdrs, &objp->locktype))
		 return FALSE;
	 if (!zdr_seqid4 (zdrs, &objp->seqid))
		 return FALSE;
	 if (!zdr_stateid4 (zdrs, &objp->lock_stateid))
		 return FALSE;
	 if (!zdr_offset4 (zdrs, &objp->offset))
		 return FALSE;
	 if (!zdr_length4 (zdrs, &objp->length))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LOCKU4res (ZDR *zdrs, LOCKU4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_stateid4 (zdrs, &objp->LOCKU4res_u.lock_stateid))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_LOOKUP4args (ZDR *zdrs, LOOKUP4args *objp)
{
	

	 if (!zdr_component4 (zdrs, &objp->objname))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LOOKUP4res (ZDR *zdrs, LOOKUP4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LOOKUPP4res (ZDR *zdrs, LOOKUPP4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_NVERIFY4args (ZDR *zdrs, NVERIFY4args *objp)
{
	

	 if (!zdr_fattr4 (zdrs, &objp->obj_attributes))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_NVERIFY4res (ZDR *zdrs, NVERIFY4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_createmode4 (ZDR *zdrs, createmode4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_createhow4 (ZDR *zdrs, createhow4 *objp)
{
	

	 if (!zdr_createmode4 (zdrs, &objp->mode))
		 return FALSE;
	switch (objp->mode) {
	case UNCHECKED4:
	case GUARDED4:
		 if (!zdr_fattr4 (zdrs, &objp->createhow4_u.createattrs))
			 return FALSE;
		break;
	case EXCLUSIVE4:
		 if (!zdr_verifier4 (zdrs, objp->createhow4_u.createverf))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_opentype4 (ZDR *zdrs, opentype4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_openflag4 (ZDR *zdrs, openflag4 *objp)
{
	

	 if (!zdr_opentype4 (zdrs, &objp->opentype))
		 return FALSE;
	switch (objp->opentype) {
	case OPEN4_CREATE:
		 if (!zdr_createhow4 (zdrs, &objp->openflag4_u.how))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_limit_by4 (ZDR *zdrs, limit_by4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_modified_limit4 (ZDR *zdrs, nfs_modified_limit4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, &objp->num_blocks))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->bytes_per_block))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_space_limit4 (ZDR *zdrs, nfs_space_limit4 *objp)
{
	

	 if (!zdr_limit_by4 (zdrs, &objp->limitby))
		 return FALSE;
	switch (objp->limitby) {
	case NFS_LIMIT_SIZE:
		 if (!zdr_uint64_t (zdrs, &objp->nfs_space_limit4_u.filesize))
			 return FALSE;
		break;
	case NFS_LIMIT_BLOCKS:
		 if (!zdr_nfs_modified_limit4 (zdrs, &objp->nfs_space_limit4_u.mod_blocks))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_open_delegation_type4 (ZDR *zdrs, open_delegation_type4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_open_claim_type4 (ZDR *zdrs, open_claim_type4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_open_claim_delegate_cur4 (ZDR *zdrs, open_claim_delegate_cur4 *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->delegate_stateid))
		 return FALSE;
	 if (!zdr_component4 (zdrs, &objp->file))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_open_claim4 (ZDR *zdrs, open_claim4 *objp)
{
	

	 if (!zdr_open_claim_type4 (zdrs, &objp->claim))
		 return FALSE;
	switch (objp->claim) {
	case CLAIM_NULL:
		 if (!zdr_component4 (zdrs, &objp->open_claim4_u.file))
			 return FALSE;
		break;
	case CLAIM_PREVIOUS:
		 if (!zdr_open_delegation_type4 (zdrs, &objp->open_claim4_u.delegate_type))
			 return FALSE;
		break;
	case CLAIM_DELEGATE_CUR:
		 if (!zdr_open_claim_delegate_cur4 (zdrs, &objp->open_claim4_u.delegate_cur_info))
			 return FALSE;
		break;
	case CLAIM_DELEGATE_PREV:
		 if (!zdr_component4 (zdrs, &objp->open_claim4_u.file_delegate_prev))
			 return FALSE;
		break;
	case CLAIM_FH:
		break;
	case CLAIM_DELEG_PREV_FH:
		break;
	case CLAIM_DELEG_CUR_FH:
		 if (!zdr_stateid4 (zdrs, &objp->open_claim4_u.oc_delegate_stateid))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_OPEN4args (ZDR *zdrs, OPEN4args *objp)
{
	

	 if (!zdr_seqid4 (zdrs, &objp->seqid))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->share_access))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->share_deny))
		 return FALSE;
	 if (!zdr_open_owner4 (zdrs, &objp->owner))
		 return FALSE;
	 if (!zdr_openflag4 (zdrs, &objp->openhow))
		 return FALSE;
	 if (!zdr_open_claim4 (zdrs, &objp->claim))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_open_read_delegation4 (ZDR *zdrs, open_read_delegation4 *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->stateid))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->recall))
		 return FALSE;
	 if (!zdr_nfsace4 (zdrs, &objp->permissions))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_open_write_delegation4 (ZDR *zdrs, open_write_delegation4 *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->stateid))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->recall))
		 return FALSE;
	 if (!zdr_nfs_space_limit4 (zdrs, &objp->space_limit))
		 return FALSE;
	 if (!zdr_nfsace4 (zdrs, &objp->permissions))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_open_delegation4 (ZDR *zdrs, open_delegation4 *objp)
{
	

	 if (!zdr_open_delegation_type4 (zdrs, &objp->delegation_type))
		 return FALSE;
	switch (objp->delegation_type) {
	case OPEN_DELEGATE_NONE:
		break;
	case OPEN_DELEGATE_READ:
		 if (!zdr_open_read_delegation4 (zdrs, &objp->open_delegation4_u.read))
			 return FALSE;
		break;
	case OPEN_DELEGATE_WRITE:
		 if (!zdr_open_write_delegation4 (zdrs, &objp->open_delegation4_u.write))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_OPEN4resok (ZDR *zdrs, OPEN4resok *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->stateid))
		 return FALSE;
	 if (!zdr_change_info4 (zdrs, &objp->cinfo))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->rflags))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->attrset))
		 return FALSE;
	 if (!zdr_open_delegation4 (zdrs, &objp->delegation))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_OPEN4res (ZDR *zdrs, OPEN4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_OPEN4resok (zdrs, &objp->OPEN4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_OPENATTR4args (ZDR *zdrs, OPENATTR4args *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->createdir))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_OPENATTR4res (ZDR *zdrs, OPENATTR4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_OPEN_CONFIRM4args (ZDR *zdrs, OPEN_CONFIRM4args *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->open_stateid))
		 return FALSE;
	 if (!zdr_seqid4 (zdrs, &objp->seqid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_OPEN_CONFIRM4resok (ZDR *zdrs, OPEN_CONFIRM4resok *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->open_stateid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_OPEN_CONFIRM4res (ZDR *zdrs, OPEN_CONFIRM4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_OPEN_CONFIRM4resok (zdrs, &objp->OPEN_CONFIRM4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_OPEN_DOWNGRADE4args (ZDR *zdrs, OPEN_DOWNGRADE4args *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->open_stateid))
		 return FALSE;
	 if (!zdr_seqid4 (zdrs, &objp->seqid))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->share_access))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->share_deny))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_OPEN_DOWNGRADE4resok (ZDR *zdrs, OPEN_DOWNGRADE4resok *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->open_stateid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_OPEN_DOWNGRADE4res (ZDR *zdrs, OPEN_DOWNGRADE4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_OPEN_DOWNGRADE4resok (zdrs, &objp->OPEN_DOWNGRADE4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_PUTFH4args (ZDR *zdrs, PUTFH4args *objp)
{
	

	 if (!zdr_nfs_fh4 (zdrs, &objp->object))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_PUTFH4res (ZDR *zdrs, PUTFH4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_PUTPUBFH4res (ZDR *zdrs, PUTPUBFH4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_PUTROOTFH4res (ZDR *zdrs, PUTROOTFH4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_READ4args (ZDR *zdrs, READ4args *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->stateid))
		 return FALSE;
	 if (!zdr_offset4 (zdrs, &objp->offset))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->count))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_READ4resok (ZDR *zdrs, READ4resok *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->eof))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->data.data_val, (u_int *) &objp->data.data_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_READ4res (ZDR *zdrs, READ4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_READ4resok (zdrs, &objp->READ4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_READDIR4args (ZDR *zdrs, READDIR4args *objp)
{
	

	 if (!zdr_nfs_cookie4 (zdrs, &objp->cookie))
		 return FALSE;
	 if (!zdr_verifier4 (zdrs, objp->cookieverf))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->dircount))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->maxcount))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->attr_request))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_entry4 (ZDR *zdrs, entry4 *objp)
{
	

	 if (!zdr_nfs_cookie4 (zdrs, &objp->cookie))
		 return FALSE;
	 if (!zdr_component4 (zdrs, &objp->name))
		 return FALSE;
	 if (!zdr_fattr4 (zdrs, &objp->attrs))
		 return FALSE;
	 if (!zdr_pointer (zdrs, (char **)&objp->nextentry, sizeof (entry4), (zdrproc_t) zdr_entry4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_dirlist4 (ZDR *zdrs, dirlist4 *objp)
{
	

	 if (!zdr_pointer (zdrs, (char **)&objp->entries, sizeof (entry4), (zdrproc_t) zdr_entry4))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->eof))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_READDIR4resok (ZDR *zdrs, READDIR4resok *objp)
{
	

	 if (!zdr_verifier4 (zdrs, objp->cookieverf))
		 return FALSE;
	 if (!zdr_dirlist4 (zdrs, &objp->reply))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_READDIR4res (ZDR *zdrs, READDIR4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_READDIR4resok (zdrs, &objp->READDIR4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_READLINK4resok (ZDR *zdrs, READLINK4resok *objp)
{
	

	 if (!zdr_linktext4 (zdrs, &objp->link))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_READLINK4res (ZDR *zdrs, READLINK4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_READLINK4resok (zdrs, &objp->READLINK4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_REMOVE4args (ZDR *zdrs, REMOVE4args *objp)
{
	

	 if (!zdr_component4 (zdrs, &objp->target))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_REMOVE4resok (ZDR *zdrs, REMOVE4resok *objp)
{
	

	 if (!zdr_change_info4 (zdrs, &objp->cinfo))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_REMOVE4res (ZDR *zdrs, REMOVE4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_REMOVE4resok (zdrs, &objp->REMOVE4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_RENAME4args (ZDR *zdrs, RENAME4args *objp)
{
	

	 if (!zdr_component4 (zdrs, &objp->oldname))
		 return FALSE;
	 if (!zdr_component4 (zdrs, &objp->newname))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_RENAME4resok (ZDR *zdrs, RENAME4resok *objp)
{
	

	 if (!zdr_change_info4 (zdrs, &objp->source_cinfo))
		 return FALSE;
	 if (!zdr_change_info4 (zdrs, &objp->target_cinfo))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_RENAME4res (ZDR *zdrs, RENAME4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_RENAME4resok (zdrs, &objp->RENAME4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_RENEW4args (ZDR *zdrs, RENEW4args *objp)
{
	

	 if (!zdr_clientid4 (zdrs, &objp->clientid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_RENEW4res (ZDR *zdrs, RENEW4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_RESTOREFH4res (ZDR *zdrs, RESTOREFH4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SAVEFH4res (ZDR *zdrs, SAVEFH4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SECINFO4args (ZDR *zdrs, SECINFO4args *objp)
{
	

	 if (!zdr_component4 (zdrs, &objp->name))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_rpc_gss_svc_t (ZDR *zdrs, rpc_gss_svc_t *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_rpcsec_gss_info (ZDR *zdrs, rpcsec_gss_info *objp)
{
	

	 if (!zdr_sec_oid4 (zdrs, &objp->oid))
		 return FALSE;
	 if (!zdr_qop4 (zdrs, &objp->qop))
		 return FALSE;
	 if (!zdr_rpc_gss_svc_t (zdrs, &objp->service))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_secinfo4 (ZDR *zdrs, secinfo4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, &objp->flavor))
		 return FALSE;
	switch (objp->flavor) {
	case RPCSEC_GSS:
		 if (!zdr_rpcsec_gss_info (zdrs, &objp->secinfo4_u.flavor_info))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_SECINFO4resok (ZDR *zdrs, SECINFO4resok *objp)
{
	

	 if (!zdr_array (zdrs, (char **)&objp->SECINFO4resok_val, (u_int *) &objp->SECINFO4resok_len, ~0,
		sizeof (secinfo4), (zdrproc_t) zdr_secinfo4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SECINFO4res (ZDR *zdrs, SECINFO4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_SECINFO4resok (zdrs, &objp->SECINFO4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_SETATTR4args (ZDR *zdrs, SETATTR4args *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->stateid))
		 return FALSE;
	 if (!zdr_fattr4 (zdrs, &objp->obj_attributes))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SETATTR4res (ZDR *zdrs, SETATTR4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->attrsset))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SETCLIENTID4args (ZDR *zdrs, SETCLIENTID4args *objp)
{
	

	 if (!zdr_nfs_client_id4 (zdrs, &objp->client))
		 return FALSE;
	 if (!zdr_cb_client4 (zdrs, &objp->callback))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->callback_ident))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SETCLIENTID4resok (ZDR *zdrs, SETCLIENTID4resok *objp)
{
	

	 if (!zdr_clientid4 (zdrs, &objp->clientid))
		 return FALSE;
	 if (!zdr_verifier4 (zdrs, objp->setclientid_confirm))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SETCLIENTID4res (ZDR *zdrs, SETCLIENTID4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_SETCLIENTID4resok (zdrs, &objp->SETCLIENTID4res_u.resok4))
			 return FALSE;
		break;
	case NFS4ERR_CLID_INUSE:
		 if (!zdr_clientaddr4 (zdrs, &objp->SETCLIENTID4res_u.client_using))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_SETCLIENTID_CONFIRM4args (ZDR *zdrs, SETCLIENTID_CONFIRM4args *objp)
{
	

	 if (!zdr_clientid4 (zdrs, &objp->clientid))
		 return FALSE;
	 if (!zdr_verifier4 (zdrs, objp->setclientid_confirm))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SETCLIENTID_CONFIRM4res (ZDR *zdrs, SETCLIENTID_CONFIRM4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_VERIFY4args (ZDR *zdrs, VERIFY4args *objp)
{
	

	 if (!zdr_fattr4 (zdrs, &objp->obj_attributes))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_VERIFY4res (ZDR *zdrs, VERIFY4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_stable_how4 (ZDR *zdrs, stable_how4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_WRITE4args (ZDR *zdrs, WRITE4args *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->stateid))
		 return FALSE;
	 if (!zdr_offset4 (zdrs, &objp->offset))
		 return FALSE;
	 if (!zdr_stable_how4 (zdrs, &objp->stable))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->data.data_val, (u_int *) &objp->data.data_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_WRITE4resok (ZDR *zdrs, WRITE4resok *objp)
{
	

	 if (!zdr_count4 (zdrs, &objp->count))
		 return FALSE;
	 if (!zdr_stable_how4 (zdrs, &objp->committed))
		 return FALSE;
	 if (!zdr_verifier4 (zdrs, objp->writeverf))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_WRITE4res (ZDR *zdrs, WRITE4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_WRITE4resok (zdrs, &objp->WRITE4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_RELEASE_LOCKOWNER4args (ZDR *zdrs, RELEASE_LOCKOWNER4args *objp)
{
	

	 if (!zdr_lock_owner4 (zdrs, &objp->lock_owner))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_RELEASE_LOCKOWNER4res (ZDR *zdrs, RELEASE_LOCKOWNER4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_gsshandle4_t (ZDR *zdrs, gsshandle4_t *objp)
{
	

	 if (!zdr_bytes (zdrs, (char **)&objp->gsshandle4_t_val, (u_int *) &objp->gsshandle4_t_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_callback_sec_parms4 (ZDR *zdrs, callback_sec_parms4 *objp)
{
	

	 if (!zdr_uint32_t (zdrs, &objp->cb_secflavor))
		 return FALSE;
	switch (objp->cb_secflavor) {
	case AUTH_NONE:
		break;
	case AUTH_SYS:
		 if (!zdr_authsys_parms (zdrs, &objp->callback_sec_parms4_u.cbsp_sys_cred))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_channel_dir_from_client4 (ZDR *zdrs, channel_dir_from_client4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_BIND_CONN_TO_SESSION4args (ZDR *zdrs, BIND_CONN_TO_SESSION4args *objp)
{
	

	 if (!zdr_sessionid4 (zdrs, objp->bctsa_sessid))
		 return FALSE;
	 if (!zdr_channel_dir_from_client4 (zdrs, &objp->bctsa_dir))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->bctsa_use_conn_in_rdma_mode))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_channel_dir_from_server4 (ZDR *zdrs, channel_dir_from_server4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_BIND_CONN_TO_SESSION4resok (ZDR *zdrs, BIND_CONN_TO_SESSION4resok *objp)
{
	

	 if (!zdr_sessionid4 (zdrs, objp->bctsr_sessid))
		 return FALSE;
	 if (!zdr_channel_dir_from_server4 (zdrs, &objp->bctsr_dir))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->bctsr_use_conn_in_rdma_mode))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_BIND_CONN_TO_SESSION4res (ZDR *zdrs, BIND_CONN_TO_SESSION4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->bctsr_status))
		 return FALSE;
	switch (objp->bctsr_status) {
	case NFS4_OK:
		 if (!zdr_BIND_CONN_TO_SESSION4resok (zdrs, &objp->BIND_CONN_TO_SESSION4res_u.bctsr_resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_state_protect_ops4 (ZDR *zdrs, state_protect_ops4 *objp)
{
	

	 if (!zdr_bitmap4 (zdrs, &objp->spo_must_enforce))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->spo_must_allow))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_ssv_sp_parms4 (ZDR *zdrs, ssv_sp_parms4 *objp)
{
	

	 if (!zdr_state_protect_ops4 (zdrs, &objp->ssp_ops))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->ssp_hash_algs.ssp_hash_algs_val, (u_int *) &objp->ssp_hash_algs.ssp_hash_algs_len, ~0,
		sizeof (sec_oid4), (zdrproc_t) zdr_sec_oid4))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->ssp_encr_algs.ssp_encr_algs_val, (u_int *) &objp->ssp_encr_algs.ssp_encr_algs_len, ~0,
		sizeof (sec_oid4), (zdrproc_t) zdr_sec_oid4))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->ssp_window))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->ssp_num_gss_handles))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_state_protect_how4 (ZDR *zdrs, state_protect_how4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_state_protect4_a (ZDR *zdrs, state_protect4_a *objp)
{
	

	 if (!zdr_state_protect_how4 (zdrs, &objp->spa_how))
		 return FALSE;
	switch (objp->spa_how) {
	case SP4_NONE:
		break;
	case SP4_MACH_CRED:
		 if (!zdr_state_protect_ops4 (zdrs, &objp->state_protect4_a_u.spa_mach_ops))
			 return FALSE;
		break;
	case SP4_SSV:
		 if (!zdr_ssv_sp_parms4 (zdrs, &objp->state_protect4_a_u.spa_ssv_parms))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_EXCHANGE_ID4args (ZDR *zdrs, EXCHANGE_ID4args *objp)
{
	

	 if (!zdr_client_owner4 (zdrs, &objp->eia_clientowner))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->eia_flags))
		 return FALSE;
	 if (!zdr_state_protect4_a (zdrs, &objp->eia_state_protect))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->eia_client_impl_id.eia_client_impl_id_val, (u_int *) &objp->eia_client_impl_id.eia_client_impl_id_len, 1,
		sizeof (nfs_impl_id4), (zdrproc_t) zdr_nfs_impl_id4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_ssv_prot_info4 (ZDR *zdrs, ssv_prot_info4 *objp)
{
	

	 if (!zdr_state_protect_ops4 (zdrs, &objp->spi_ops))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->spi_hash_alg))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->spi_encr_alg))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->spi_ssv_len))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->spi_window))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->spi_handles.spi_handles_val, (u_int *) &objp->spi_handles.spi_handles_len, ~0,
		sizeof (gsshandle4_t), (zdrproc_t) zdr_gsshandle4_t))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_state_protect4_r (ZDR *zdrs, state_protect4_r *objp)
{
	

	 if (!zdr_state_protect_how4 (zdrs, &objp->spr_how))
		 return FALSE;
	switch (objp->spr_how) {
	case SP4_NONE:
		break;
	case SP4_MACH_CRED:
		 if (!zdr_state_protect_ops4 (zdrs, &objp->state_protect4_r_u.spr_mach_ops))
			 return FALSE;
		break;
	case SP4_SSV:
		 if (!zdr_ssv_prot_info4 (zdrs, &objp->state_protect4_r_u.spr_ssv_info))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_EXCHANGE_ID4resok (ZDR *zdrs, EXCHANGE_ID4resok *objp)
{
	

	 if (!zdr_clientid4 (zdrs, &objp->eir_clientid))
		 return FALSE;
	 if (!zdr_sequenceid4 (zdrs, &objp->eir_sequenceid))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->eir_flags))
		 return FALSE;
	 if (!zdr_state_protect4_r (zdrs, &objp->eir_state_protect))
		 return FALSE;
	 if (!zdr_server_owner4 (zdrs, &objp->eir_server_owner))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->eir_server_scope.eir_server_scope_val, (u_int *) &objp->eir_server_scope.eir_server_scope_len, NFS4_OPAQUE_LIMIT))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->eir_server_impl_id.eir_server_impl_id_val, (u_int *) &objp->eir_server_impl_id.eir_server_impl_id_len, 1,
		sizeof (nfs_impl_id4), (zdrproc_t) zdr_nfs_impl_id4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_EXCHANGE_ID4res (ZDR *zdrs, EXCHANGE_ID4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->eir_status))
		 return FALSE;
	switch (objp->eir_status) {
	case NFS4_OK:
		 if (!zdr_EXCHANGE_ID4resok (zdrs, &objp->EXCHANGE_ID4res_u.eir_resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_channel_attrs4 (ZDR *zdrs, channel_attrs4 *objp)
{
	

	 if (!zdr_count4 (zdrs, &objp->ca_headerpadsize))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->ca_maxrequestsize))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->ca_maxresponsesize))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->ca_maxresponsesize_cached))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->ca_maxoperations))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->ca_maxrequests))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->ca_rdma_ird.ca_rdma_ird_val, (u_int *) &objp->ca_rdma_ird.ca_rdma_ird_len, 1,
		sizeof (uint32_t), (zdrproc_t) zdr_uint32_t))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CREATE_SESSION4args (ZDR *zdrs, CREATE_SESSION4args *objp)
{
	

	 if (!zdr_clientid4 (zdrs, &objp->csa_clientid))
		 return FALSE;
	 if (!zdr_sequenceid4 (zdrs, &objp->csa_sequence))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->csa_flags))
		 return FALSE;
	 if (!zdr_channel_attrs4 (zdrs, &objp->csa_fore_chan_attrs))
		 return FALSE;
	 if (!zdr_channel_attrs4 (zdrs, &objp->csa_back_chan_attrs))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->csa_cb_program))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->csa_sec_parms.csa_sec_parms_val, (u_int *) &objp->csa_sec_parms.csa_sec_parms_len, ~0,
		sizeof (callback_sec_parms4), (zdrproc_t) zdr_callback_sec_parms4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CREATE_SESSION4resok (ZDR *zdrs, CREATE_SESSION4resok *objp)
{
	

	 if (!zdr_sessionid4 (zdrs, objp->csr_sessionid))
		 return FALSE;
	 if (!zdr_sequenceid4 (zdrs, &objp->csr_sequence))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->csr_flags))
		 return FALSE;
	 if (!zdr_channel_attrs4 (zdrs, &objp->csr_fore_chan_attrs))
		 return FALSE;
	 if (!zdr_channel_attrs4 (zdrs, &objp->csr_back_chan_attrs))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CREATE_SESSION4res (ZDR *zdrs, CREATE_SESSION4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->csr_status))
		 return FALSE;
	switch (objp->csr_status) {
	case NFS4_OK:
		 if (!zdr_CREATE_SESSION4resok (zdrs, &objp->CREATE_SESSION4res_u.csr_resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_DESTROY_SESSION4args (ZDR *zdrs, DESTROY_SESSION4args *objp)
{
	

	 if (!zdr_sessionid4 (zdrs, objp->dsa_sessionid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_DESTROY_SESSION4res (ZDR *zdrs, DESTROY_SESSION4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->dsr_status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_FREE_STATEID4args (ZDR *zdrs, FREE_STATEID4args *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->fsa_stateid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_FREE_STATEID4res (ZDR *zdrs, FREE_STATEID4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->fsr_status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_attr_notice4 (ZDR *zdrs, attr_notice4 *objp)
{
	

	 if (!zdr_nfstime4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GET_DIR_DELEGATION4args (ZDR *zdrs, GET_DIR_DELEGATION4args *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->gdda_signal_deleg_avail))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->gdda_notification_types))
		 return FALSE;
	 if (!zdr_attr_notice4 (zdrs, &objp->gdda_child_attr_delay))
		 return FALSE;
	 if (!zdr_attr_notice4 (zdrs, &objp->gdda_dir_attr_delay))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->gdda_child_attributes))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->gdda_dir_attributes))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GET_DIR_DELEGATION4resok (ZDR *zdrs, GET_DIR_DELEGATION4resok *objp)
{
	

	 if (!zdr_verifier4 (zdrs, objp->gddr_cookieverf))
		 return FALSE;
	 if (!zdr_stateid4 (zdrs, &objp->gddr_stateid))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->gddr_notification))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->gddr_child_attributes))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->gddr_dir_attributes))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_gddrnf4_status (ZDR *zdrs, gddrnf4_status *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GET_DIR_DELEGATION4res_non_fatal (ZDR *zdrs, GET_DIR_DELEGATION4res_non_fatal *objp)
{
	

	 if (!zdr_gddrnf4_status (zdrs, &objp->gddrnf_status))
		 return FALSE;
	switch (objp->gddrnf_status) {
	case GDD4_OK:
		 if (!zdr_GET_DIR_DELEGATION4resok (zdrs, &objp->GET_DIR_DELEGATION4res_non_fatal_u.gddrnf_resok4))
			 return FALSE;
		break;
	case GDD4_UNAVAIL:
		 if (!zdr_bool (zdrs, &objp->GET_DIR_DELEGATION4res_non_fatal_u.gddrnf_will_signal_deleg_avail))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_GET_DIR_DELEGATION4res (ZDR *zdrs, GET_DIR_DELEGATION4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->gddr_status))
		 return FALSE;
	switch (objp->gddr_status) {
	case NFS4_OK:
		 if (!zdr_GET_DIR_DELEGATION4res_non_fatal (zdrs, &objp->GET_DIR_DELEGATION4res_u.gddr_res_non_fatal4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_GETDEVICEINFO4args (ZDR *zdrs, GETDEVICEINFO4args *objp)
{
	

	 if (!zdr_deviceid4 (zdrs, objp->gdia_device_id))
		 return FALSE;
	 if (!zdr_layouttype4 (zdrs, &objp->gdia_layout_type))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->gdia_maxcount))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->gdia_notify_types))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETDEVICEINFO4resok (ZDR *zdrs, GETDEVICEINFO4resok *objp)
{
	

	 if (!zdr_device_addr4 (zdrs, &objp->gdir_device_addr))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->gdir_notification))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETDEVICEINFO4res (ZDR *zdrs, GETDEVICEINFO4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->gdir_status))
		 return FALSE;
	switch (objp->gdir_status) {
	case NFS4_OK:
		 if (!zdr_GETDEVICEINFO4resok (zdrs, &objp->GETDEVICEINFO4res_u.gdir_resok4))
			 return FALSE;
		break;
	case NFS4ERR_TOOSMALL:
		 if (!zdr_count4 (zdrs, &objp->GETDEVICEINFO4res_u.gdir_mincount))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_GETDEVICELIST4args (ZDR *zdrs, GETDEVICELIST4args *objp)
{
	

	 if (!zdr_layouttype4 (zdrs, &objp->gdla_layout_type))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->gdla_maxdevices))
		 return FALSE;
	 if (!zdr_nfs_cookie4 (zdrs, &objp->gdla_cookie))
		 return FALSE;
	 if (!zdr_verifier4 (zdrs, objp->gdla_cookieverf))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETDEVICELIST4resok (ZDR *zdrs, GETDEVICELIST4resok *objp)
{
	

	 if (!zdr_nfs_cookie4 (zdrs, &objp->gdlr_cookie))
		 return FALSE;
	 if (!zdr_verifier4 (zdrs, objp->gdlr_cookieverf))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->gdlr_deviceid_list.gdlr_deviceid_list_val, (u_int *) &objp->gdlr_deviceid_list.gdlr_deviceid_list_len, ~0,
		sizeof (deviceid4), (zdrproc_t) zdr_deviceid4))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->gdlr_eof))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_GETDEVICELIST4res (ZDR *zdrs, GETDEVICELIST4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->gdlr_status))
		 return FALSE;
	switch (objp->gdlr_status) {
	case NFS4_OK:
		 if (!zdr_GETDEVICELIST4resok (zdrs, &objp->GETDEVICELIST4res_u.gdlr_resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_newtime4 (ZDR *zdrs, newtime4 *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->nt_timechanged))
		 return FALSE;
	switch (objp->nt_timechanged) {
	case TRUE:
		 if (!zdr_nfstime4 (zdrs, &objp->newtime4_u.nt_time))
			 return FALSE;
		break;
	case FALSE:
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_newoffset4 (ZDR *zdrs, newoffset4 *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->no_newoffset))
		 return FALSE;
	switch (objp->no_newoffset) {
	case TRUE:
		 if (!zdr_offset4 (zdrs, &objp->newoffset4_u.no_offset))
			 return FALSE;
		break;
	case FALSE:
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_LAYOUTCOMMIT4args (ZDR *zdrs, LAYOUTCOMMIT4args *objp)
{
	

	 if (!zdr_offset4 (zdrs, &objp->loca_offset))
		 return FALSE;
	 if (!zdr_length4 (zdrs, &objp->loca_length))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->loca_reclaim))
		 return FALSE;
	 if (!zdr_stateid4 (zdrs, &objp->loca_stateid))
		 return FALSE;
	 if (!zdr_newoffset4 (zdrs, &objp->loca_last_write_offset))
		 return FALSE;
	 if (!zdr_newtime4 (zdrs, &objp->loca_time_modify))
		 return FALSE;
	 if (!zdr_layoutupdate4 (zdrs, &objp->loca_layoutupdate))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_newsize4 (ZDR *zdrs, newsize4 *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->ns_sizechanged))
		 return FALSE;
	switch (objp->ns_sizechanged) {
	case TRUE:
		 if (!zdr_length4 (zdrs, &objp->newsize4_u.ns_size))
			 return FALSE;
		break;
	case FALSE:
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_LAYOUTCOMMIT4resok (ZDR *zdrs, LAYOUTCOMMIT4resok *objp)
{
	

	 if (!zdr_newsize4 (zdrs, &objp->locr_newsize))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LAYOUTCOMMIT4res (ZDR *zdrs, LAYOUTCOMMIT4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->locr_status))
		 return FALSE;
	switch (objp->locr_status) {
	case NFS4_OK:
		 if (!zdr_LAYOUTCOMMIT4resok (zdrs, &objp->LAYOUTCOMMIT4res_u.locr_resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_LAYOUTGET4args (ZDR *zdrs, LAYOUTGET4args *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->loga_signal_layout_avail))
		 return FALSE;
	 if (!zdr_layouttype4 (zdrs, &objp->loga_layout_type))
		 return FALSE;
	 if (!zdr_layoutiomode4 (zdrs, &objp->loga_iomode))
		 return FALSE;
	 if (!zdr_offset4 (zdrs, &objp->loga_offset))
		 return FALSE;
	 if (!zdr_length4 (zdrs, &objp->loga_length))
		 return FALSE;
	 if (!zdr_length4 (zdrs, &objp->loga_minlength))
		 return FALSE;
	 if (!zdr_stateid4 (zdrs, &objp->loga_stateid))
		 return FALSE;
	 if (!zdr_count4 (zdrs, &objp->loga_maxcount))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LAYOUTGET4resok (ZDR *zdrs, LAYOUTGET4resok *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->logr_return_on_close))
		 return FALSE;
	 if (!zdr_stateid4 (zdrs, &objp->logr_stateid))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->logr_layout.logr_layout_val, (u_int *) &objp->logr_layout.logr_layout_len, ~0,
		sizeof (layout4), (zdrproc_t) zdr_layout4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_LAYOUTGET4res (ZDR *zdrs, LAYOUTGET4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->logr_status))
		 return FALSE;
	switch (objp->logr_status) {
	case NFS4_OK:
		 if (!zdr_LAYOUTGET4resok (zdrs, &objp->LAYOUTGET4res_u.logr_resok4))
			 return FALSE;
		break;
	case NFS4ERR_LAYOUTTRYLATER:
		 if (!zdr_bool (zdrs, &objp->LAYOUTGET4res_u.logr_will_signal_layout_avail))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_layoutreturn_type4 (ZDR *zdrs, layoutreturn_type4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_layoutreturn_file4 (ZDR *zdrs, layoutreturn_file4 *objp)
{
	

	 if (!zdr_offset4 (zdrs, &objp->lrf_offset))
		 return FALSE;
	 if (!zdr_length4 (zdrs, &objp->lrf_length))
		 return FALSE;
	 if (!zdr_stateid4 (zdrs, &objp->lrf_stateid))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->lrf_body.lrf_body_val, (u_int *) &objp->lrf_body.lrf_body_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_layoutreturn4 (ZDR *zdrs, layoutreturn4 *objp)
{
	

	 if (!zdr_layoutreturn_type4 (zdrs, &objp->lr_returntype))
		 return FALSE;
	switch (objp->lr_returntype) {
	case LAYOUTRETURN4_FILE:
		 if (!zdr_layoutreturn_file4 (zdrs, &objp->layoutreturn4_u.lr_layout))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_LAYOUTRETURN4args (ZDR *zdrs, LAYOUTRETURN4args *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->lora_reclaim))
		 return FALSE;
	 if (!zdr_layouttype4 (zdrs, &objp->lora_layout_type))
		 return FALSE;
	 if (!zdr_layoutiomode4 (zdrs, &objp->lora_iomode))
		 return FALSE;
	 if (!zdr_layoutreturn4 (zdrs, &objp->lora_layoutreturn))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_layoutreturn_stateid (ZDR *zdrs, layoutreturn_stateid *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->lrs_present))
		 return FALSE;
	switch (objp->lrs_present) {
	case TRUE:
		 if (!zdr_stateid4 (zdrs, &objp->layoutreturn_stateid_u.lrs_stateid))
			 return FALSE;
		break;
	case FALSE:
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_LAYOUTRETURN4res (ZDR *zdrs, LAYOUTRETURN4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->lorr_status))
		 return FALSE;
	switch (objp->lorr_status) {
	case NFS4_OK:
		 if (!zdr_layoutreturn_stateid (zdrs, &objp->LAYOUTRETURN4res_u.lorr_stateid))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_secinfo_style4 (ZDR *zdrs, secinfo_style4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SECINFO_NO_NAME4args (ZDR *zdrs, SECINFO_NO_NAME4args *objp)
{
	

	 if (!zdr_secinfo_style4 (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SECINFO_NO_NAME4res (ZDR *zdrs, SECINFO_NO_NAME4res *objp)
{
	

	 if (!zdr_SECINFO4res (zdrs, objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SEQUENCE4args (ZDR *zdrs, SEQUENCE4args *objp)
{
	

	 if (!zdr_sessionid4 (zdrs, objp->sa_sessionid))
		 return FALSE;
	 if (!zdr_sequenceid4 (zdrs, &objp->sa_sequenceid))
		 return FALSE;
	 if (!zdr_slotid4 (zdrs, &objp->sa_slotid))
		 return FALSE;
	 if (!zdr_slotid4 (zdrs, &objp->sa_highest_slotid))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->sa_cachethis))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SEQUENCE4resok (ZDR *zdrs, SEQUENCE4resok *objp)
{
	

	 if (!zdr_sessionid4 (zdrs, objp->sr_sessionid))
		 return FALSE;
	 if (!zdr_sequenceid4 (zdrs, &objp->sr_sequenceid))
		 return FALSE;
	 if (!zdr_slotid4 (zdrs, &objp->sr_slotid))
		 return FALSE;
	 if (!zdr_slotid4 (zdrs, &objp->sr_highest_slotid))
		 return FALSE;
	 if (!zdr_slotid4 (zdrs, &objp->sr_target_highest_slotid))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->sr_status_flags))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SEQUENCE4res (ZDR *zdrs, SEQUENCE4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->sr_status))
		 return FALSE;
	switch (objp->sr_status) {
	case NFS4_OK:
		 if (!zdr_SEQUENCE4resok (zdrs, &objp->SEQUENCE4res_u.sr_resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_ssa_digest_input4 (ZDR *zdrs, ssa_digest_input4 *objp)
{
	

	 if (!zdr_SEQUENCE4args (zdrs, &objp->sdi_seqargs))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SET_SSV4args (ZDR *zdrs, SET_SSV4args *objp)
{
	

	 if (!zdr_bytes (zdrs, (char **)&objp->ssa_ssv.ssa_ssv_val, (u_int *) &objp->ssa_ssv.ssa_ssv_len, ~0))
		 return FALSE;
	 if (!zdr_bytes (zdrs, (char **)&objp->ssa_digest.ssa_digest_val, (u_int *) &objp->ssa_digest.ssa_digest_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_ssr_digest_input4 (ZDR *zdrs, ssr_digest_input4 *objp)
{
	

	 if (!zdr_SEQUENCE4res (zdrs, &objp->sdi_seqres))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SET_SSV4resok (ZDR *zdrs, SET_SSV4resok *objp)
{
	

	 if (!zdr_bytes (zdrs, (char **)&objp->ssr_digest.ssr_digest_val, (u_int *) &objp->ssr_digest.ssr_digest_len, ~0))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_SET_SSV4res (ZDR *zdrs, SET_SSV4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->ssr_status))
		 return FALSE;
	switch (objp->ssr_status) {
	case NFS4_OK:
		 if (!zdr_SET_SSV4resok (zdrs, &objp->SET_SSV4res_u.ssr_resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_TEST_STATEID4args (ZDR *zdrs, TEST_STATEID4args *objp)
{
	

	 if (!zdr_array (zdrs, (char **)&objp->ts_stateids.ts_stateids_val, (u_int *) &objp->ts_stateids.ts_stateids_len, ~0,
		sizeof (stateid4), (zdrproc_t) zdr_stateid4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_TEST_STATEID4resok (ZDR *zdrs, TEST_STATEID4resok *objp)
{
	

	 if (!zdr_array (zdrs, (char **)&objp->tsr_status_codes.tsr_status_codes_val, (u_int *) &objp->tsr_status_codes.tsr_status_codes_len, ~0,
		sizeof (nfsstat4), (zdrproc_t) zdr_nfsstat4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_TEST_STATEID4res (ZDR *zdrs, TEST_STATEID4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->tsr_status))
		 return FALSE;
	switch (objp->tsr_status) {
	case NFS4_OK:
		 if (!zdr_TEST_STATEID4resok (zdrs, &objp->TEST_STATEID4res_u.tsr_resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_deleg_claim4 (ZDR *zdrs, deleg_claim4 *objp)
{
	

	 if (!zdr_open_claim_type4 (zdrs, &objp->dc_claim))
		 return FALSE;
	switch (objp->dc_claim) {
	case CLAIM_FH:
		break;
	case CLAIM_DELEG_PREV_FH:
		break;
	case CLAIM_PREVIOUS:
		 if (!zdr_open_delegation_type4 (zdrs, &objp->deleg_claim4_u.dc_delegate_type))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_WANT_DELEGATION4args (ZDR *zdrs, WANT_DELEGATION4args *objp)
{
	

	 if (!zdr_uint32_t (zdrs, &objp->wda_want))
		 return FALSE;
	 if (!zdr_deleg_claim4 (zdrs, &objp->wda_claim))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_WANT_DELEGATION4res (ZDR *zdrs, WANT_DELEGATION4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->wdr_status))
		 return FALSE;
	switch (objp->wdr_status) {
	case NFS4_OK:
		 if (!zdr_open_delegation4 (zdrs, &objp->WANT_DELEGATION4res_u.wdr_resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_DESTROY_CLIENTID4args (ZDR *zdrs, DESTROY_CLIENTID4args *objp)
{
	

	 if (!zdr_clientid4 (zdrs, &objp->dca_clientid))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_DESTROY_CLIENTID4res (ZDR *zdrs, DESTROY_CLIENTID4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->dcr_status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_RECLAIM_COMPLETE4args (ZDR *zdrs, RECLAIM_COMPLETE4args *objp)
{
	

	 if (!zdr_bool (zdrs, &objp->rca_one_fs))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_RECLAIM_COMPLETE4res (ZDR *zdrs, RECLAIM_COMPLETE4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->rcr_status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_ILLEGAL4res (ZDR *zdrs, ILLEGAL4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_opnum4 (ZDR *zdrs, nfs_opnum4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_argop4 (ZDR *zdrs, nfs_argop4 *objp)
{
	

	 if (!zdr_nfs_opnum4 (zdrs, &objp->argop))
		 return FALSE;
	switch (objp->argop) {
	case OP_ACCESS:
		 if (!zdr_ACCESS4args (zdrs, &objp->nfs_argop4_u.opaccess))
			 return FALSE;
		break;
	case OP_CLOSE:
		 if (!zdr_CLOSE4args (zdrs, &objp->nfs_argop4_u.opclose))
			 return FALSE;
		break;
	case OP_COMMIT:
		 if (!zdr_COMMIT4args (zdrs, &objp->nfs_argop4_u.opcommit))
			 return FALSE;
		break;
	case OP_CREATE:
		 if (!zdr_CREATE4args (zdrs, &objp->nfs_argop4_u.opcreate))
			 return FALSE;
		break;
	case OP_DELEGPURGE:
		 if (!zdr_DELEGPURGE4args (zdrs, &objp->nfs_argop4_u.opdelegpurge))
			 return FALSE;
		break;
	case OP_DELEGRETURN:
		 if (!zdr_DELEGRETURN4args (zdrs, &objp->nfs_argop4_u.opdelegreturn))
			 return FALSE;
		break;
	case OP_GETATTR:
		 if (!zdr_GETATTR4args (zdrs, &objp->nfs_argop4_u.opgetattr))
			 return FALSE;
		break;
	case OP_GETFH:
		break;
	case OP_LINK:
		 if (!zdr_LINK4args (zdrs, &objp->nfs_argop4_u.oplink))
			 return FALSE;
		break;
	case OP_LOCK:
		 if (!zdr_LOCK4args (zdrs, &objp->nfs_argop4_u.oplock))
			 return FALSE;
		break;
	case OP_LOCKT:
		 if (!zdr_LOCKT4args (zdrs, &objp->nfs_argop4_u.oplockt))
			 return FALSE;
		break;
	case OP_LOCKU:
		 if (!zdr_LOCKU4args (zdrs, &objp->nfs_argop4_u.oplocku))
			 return FALSE;
		break;
	case OP_LOOKUP:
		 if (!zdr_LOOKUP4args (zdrs, &objp->nfs_argop4_u.oplookup))
			 return FALSE;
		break;
	case OP_LOOKUPP:
		break;
	case OP_NVERIFY:
		 if (!zdr_NVERIFY4args (zdrs, &objp->nfs_argop4_u.opnverify))
			 return FALSE;
		break;
	case OP_OPEN:
		 if (!zdr_OPEN4args (zdrs, &objp->nfs_argop4_u.opopen))
			 return FALSE;
		break;
	case OP_OPENATTR:
		 if (!zdr_OPENATTR4args (zdrs, &objp->nfs_argop4_u.opopenattr))
			 return FALSE;
		break;
	case OP_OPEN_CONFIRM:
		 if (!zdr_OPEN_CONFIRM4args (zdrs, &objp->nfs_argop4_u.opopen_confirm))
			 return FALSE;
		break;
	case OP_OPEN_DOWNGRADE:
		 if (!zdr_OPEN_DOWNGRADE4args (zdrs, &objp->nfs_argop4_u.opopen_downgrade))
			 return FALSE;
		break;
	case OP_PUTFH:
		 if (!zdr_PUTFH4args (zdrs, &objp->nfs_argop4_u.opputfh))
			 return FALSE;
		break;
	case OP_PUTPUBFH:
		break;
	case OP_PUTROOTFH:
		break;
	case OP_READ:
		 if (!zdr_READ4args (zdrs, &objp->nfs_argop4_u.opread))
			 return FALSE;
		break;
	case OP_READDIR:
		 if (!zdr_READDIR4args (zdrs, &objp->nfs_argop4_u.opreaddir))
			 return FALSE;
		break;
	case OP_READLINK:
		break;
	case OP_REMOVE:
		 if (!zdr_REMOVE4args (zdrs, &objp->nfs_argop4_u.opremove))
			 return FALSE;
		break;
	case OP_RENAME:
		 if (!zdr_RENAME4args (zdrs, &objp->nfs_argop4_u.oprename))
			 return FALSE;
		break;
	case OP_RENEW:
		 if (!zdr_RENEW4args (zdrs, &objp->nfs_argop4_u.oprenew))
			 return FALSE;
		break;
	case OP_RESTOREFH:
		break;
	case OP_SAVEFH:
		break;
	case OP_SECINFO:
		 if (!zdr_SECINFO4args (zdrs, &objp->nfs_argop4_u.opsecinfo))
			 return FALSE;
		break;
	case OP_SETATTR:
		 if (!zdr_SETATTR4args (zdrs, &objp->nfs_argop4_u.opsetattr))
			 return FALSE;
		break;
	case OP_SETCLIENTID:
		 if (!zdr_SETCLIENTID4args (zdrs, &objp->nfs_argop4_u.opsetclientid))
			 return FALSE;
		break;
	case OP_SETCLIENTID_CONFIRM:
		 if (!zdr_SETCLIENTID_CONFIRM4args (zdrs, &objp->nfs_argop4_u.opsetclientid_confirm))
			 return FALSE;
		break;
	case OP_VERIFY:
		 if (!zdr_VERIFY4args (zdrs, &objp->nfs_argop4_u.opverify))
			 return FALSE;
		break;
	case OP_WRITE:
		 if (!zdr_WRITE4args (zdrs, &objp->nfs_argop4_u.opwrite))
			 return FALSE;
		break;
	case OP_RELEASE_LOCKOWNER:
		 if (!zdr_RELEASE_LOCKOWNER4args (zdrs, &objp->nfs_argop4_u.oprelease_lockowner))
			 return FALSE;
		break;
	case OP_BIND_CONN_TO_SESSION:
		 if (!zdr_BIND_CONN_TO_SESSION4args (zdrs, &objp->nfs_argop4_u.opbindconntosession))
			 return FALSE;
		break;
	case OP_EXCHANGE_ID:
		 if (!zdr_EXCHANGE_ID4args (zdrs, &objp->nfs_argop4_u.opexchangeid))
			 return FALSE;
		break;
	case OP_CREATE_SESSION:
		 if (!zdr_CREATE_SESSION4args (zdrs, &objp->nfs_argop4_u.opcreatesession))
			 return FALSE;
		break;
	case OP_DESTROY_SESSION:
		 if (!zdr_DESTROY_SESSION4args (zdrs, &objp->nfs_argop4_u.opdestroysession))
			 return FALSE;
		break;
	case OP_FREE_STATEID:
		 if (!zdr_FREE_STATEID4args (zdrs, &objp->nfs_argop4_u.opfreestateid))
			 return FALSE;
		break;
	case OP_GET_DIR_DELEGATION:
		 if (!zdr_GET_DIR_DELEGATION4args (zdrs, &objp->nfs_argop4_u.opgetdirdelegation))
			 return FALSE;
		break;
	case OP_GETDEVICEINFO:
		 if (!zdr_GETDEVICEINFO4args (zdrs, &objp->nfs_argop4_u.opgetdeviceinfo))
			 return FALSE;
		break;
	case OP_GETDEVICELIST:
		 if (!zdr_GETDEVICELIST4args (zdrs, &objp->nfs_argop4_u.opgetdevicelist))
			 return FALSE;
		break;
	case OP_LAYOUTCOMMIT:
		 if (!zdr_LAYOUTCOMMIT4args (zdrs, &objp->nfs_argop4_u.oplayoutcommit))
			 return FALSE;
		break;
	case OP_LAYOUTGET:
		 if (!zdr_LAYOUTGET4args (zdrs, &objp->nfs_argop4_u.oplayoutget))
			 return FALSE;
		break;
	case OP_LAYOUTRETURN:
		 if (!zdr_LAYOUTRETURN4args (zdrs, &objp->nfs_argop4_u.oplayoutreturn))
			 return FALSE;
		break;
	case OP_SECINFO_NO_NAME:
		 if (!zdr_SECINFO_NO_NAME4args (zdrs, &objp->nfs_argop4_u.opsecinfononame))
			 return FALSE;
		break;
	case OP_SEQUENCE:
		 if (!zdr_SEQUENCE4args (zdrs, &objp->nfs_argop4_u.opsequence))
			 return FALSE;
		break;
	case OP_SET_SSV:
		 if (!zdr_SET_SSV4args (zdrs, &objp->nfs_argop4_u.opsetssv))
			 return FALSE;
		break;
	case OP_TEST_STATEID:
		 if (!zdr_TEST_STATEID4args (zdrs, &objp->nfs_argop4_u.opteststateid))
			 return FALSE;
		break;
	case OP_WANT_DELEGATION:
		 if (!zdr_WANT_DELEGATION4args (zdrs, &objp->nfs_argop4_u.opwantdelegation))
			 return FALSE;
		break;
	case OP_DESTROY_CLIENTID:
		 if (!zdr_DESTROY_CLIENTID4args (zdrs, &objp->nfs_argop4_u.opdestroyclientid))
			 return FALSE;
		break;
	case OP_RECLAIM_COMPLETE:
		 if (!zdr_RECLAIM_COMPLETE4args (zdrs, &objp->nfs_argop4_u.opreclaimcomplete))
			 return FALSE;
		break;
	case OP_ILLEGAL:
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_nfs_resop4 (ZDR *zdrs, nfs_resop4 *objp)
{
	

	 if (!zdr_nfs_opnum4 (zdrs, &objp->resop))
		 return FALSE;
	switch (objp->resop) {
	case OP_ACCESS:
		 if (!zdr_ACCESS4res (zdrs, &objp->nfs_resop4_u.opaccess))
			 return FALSE;
		break;
	case OP_CLOSE:
		 if (!zdr_CLOSE4res (zdrs, &objp->nfs_resop4_u.opclose))
			 return FALSE;
		break;
	case OP_COMMIT:
		 if (!zdr_COMMIT4res (zdrs, &objp->nfs_resop4_u.opcommit))
			 return FALSE;
		break;
	case OP_CREATE:
		 if (!zdr_CREATE4res (zdrs, &objp->nfs_resop4_u.opcreate))
			 return FALSE;
		break;
	case OP_DELEGPURGE:
		 if (!zdr_DELEGPURGE4res (zdrs, &objp->nfs_resop4_u.opdelegpurge))
			 return FALSE;
		break;
	case OP_DELEGRETURN:
		 if (!zdr_DELEGRETURN4res (zdrs, &objp->nfs_resop4_u.opdelegreturn))
			 return FALSE;
		break;
	case OP_GETATTR:
		 if (!zdr_GETATTR4res (zdrs, &objp->nfs_resop4_u.opgetattr))
			 return FALSE;
		break;
	case OP_GETFH:
		 if (!zdr_GETFH4res (zdrs, &objp->nfs_resop4_u.opgetfh))
			 return FALSE;
		break;
	case OP_LINK:
		 if (!zdr_LINK4res (zdrs, &objp->nfs_resop4_u.oplink))
			 return FALSE;
		break;
	case OP_LOCK:
		 if (!zdr_LOCK4res (zdrs, &objp->nfs_resop4_u.oplock))
			 return FALSE;
		break;
	case OP_LOCKT:
		 if (!zdr_LOCKT4res (zdrs, &objp->nfs_resop4_u.oplockt))
			 return FALSE;
		break;
	case OP_LOCKU:
		 if (!zdr_LOCKU4res (zdrs, &objp->nfs_resop4_u.oplocku))
			 return FALSE;
		break;
	case OP_LOOKUP:
		 if (!zdr_LOOKUP4res (zdrs, &objp->nfs_resop4_u.oplookup))
			 return FALSE;
		break;
	case OP_LOOKUPP:
		 if (!zdr_LOOKUPP4res (zdrs, &objp->nfs_resop4_u.oplookupp))
			 return FALSE;
		break;
	case OP_NVERIFY:
		 if (!zdr_NVERIFY4res (zdrs, &objp->nfs_resop4_u.opnverify))
			 return FALSE;
		break;
	case OP_OPEN:
		 if (!zdr_OPEN4res (zdrs, &objp->nfs_resop4_u.opopen))
			 return FALSE;
		break;
	case OP_OPENATTR:
		 if (!zdr_OPENATTR4res (zdrs, &objp->nfs_resop4_u.opopenattr))
			 return FALSE;
		break;
	case OP_OPEN_CONFIRM:
		 if (!zdr_OPEN_CONFIRM4res (zdrs, &objp->nfs_resop4_u.opopen_confirm))
			 return FALSE;
		break;
	case OP_OPEN_DOWNGRADE:
		 if (!zdr_OPEN_DOWNGRADE4res (zdrs, &objp->nfs_resop4_u.opopen_downgrade))
			 return FALSE;
		break;
	case OP_PUTFH:
		 if (!zdr_PUTFH4res (zdrs, &objp->nfs_resop4_u.opputfh))
			 return FALSE;
		break;
	case OP_PUTPUBFH:
		 if (!zdr_PUTPUBFH4res (zdrs, &objp->nfs_resop4_u.opputpubfh))
			 return FALSE;
		break;
	case OP_PUTROOTFH:
		 if (!zdr_PUTROOTFH4res (zdrs, &objp->nfs_resop4_u.opputrootfh))
			 return FALSE;
		break;
	case OP_READ:
		 if (!zdr_READ4res (zdrs, &objp->nfs_resop4_u.opread))
			 return FALSE;
		break;
	case OP_READDIR:
		 if (!zdr_READDIR4res (zdrs, &objp->nfs_resop4_u.opreaddir))
			 return FALSE;
		break;
	case OP_READLINK:
		 if (!zdr_READLINK4res (zdrs, &objp->nfs_resop4_u.opreadlink))
			 return FALSE;
		break;
	case OP_REMOVE:
		 if (!zdr_REMOVE4res (zdrs, &objp->nfs_resop4_u.opremove))
			 return FALSE;
		break;
	case OP_RENAME:
		 if (!zdr_RENAME4res (zdrs, &objp->nfs_resop4_u.oprename))
			 return FALSE;
		break;
	case OP_RENEW:
		 if (!zdr_RENEW4res (zdrs, &objp->nfs_resop4_u.oprenew))
			 return FALSE;
		break;
	case OP_RESTOREFH:
		 if (!zdr_RESTOREFH4res (zdrs, &objp->nfs_resop4_u.oprestorefh))
			 return FALSE;
		break;
	case OP_SAVEFH:
		 if (!zdr_SAVEFH4res (zdrs, &objp->nfs_resop4_u.opsavefh))
			 return FALSE;
		break;
	case OP_SECINFO:
		 if (!zdr_SECINFO4res (zdrs, &objp->nfs_resop4_u.opsecinfo))
			 return FALSE;
		break;
	case OP_SETATTR:
		 if (!zdr_SETATTR4res (zdrs, &objp->nfs_resop4_u.opsetattr))
			 return FALSE;
		break;
	case OP_SETCLIENTID:
		 if (!zdr_SETCLIENTID4res (zdrs, &objp->nfs_resop4_u.opsetclientid))
			 return FALSE;
		break;
	case OP_SETCLIENTID_CONFIRM:
		 if (!zdr_SETCLIENTID_CONFIRM4res (zdrs, &objp->nfs_resop4_u.opsetclientid_confirm))
			 return FALSE;
		break;
	case OP_VERIFY:
		 if (!zdr_VERIFY4res (zdrs, &objp->nfs_resop4_u.opverify))
			 return FALSE;
		break;
	case OP_WRITE:
		 if (!zdr_WRITE4res (zdrs, &objp->nfs_resop4_u.opwrite))
			 return FALSE;
		break;
	case OP_RELEASE_LOCKOWNER:
		 if (!zdr_RELEASE_LOCKOWNER4res (zdrs, &objp->nfs_resop4_u.oprelease_lockowner))
			 return FALSE;
		break;
	case OP_BIND_CONN_TO_SESSION:
		 if (!zdr_BIND_CONN_TO_SESSION4res (zdrs, &objp->nfs_resop4_u.opbindconntosession))
			 return FALSE;
		break;
	case OP_EXCHANGE_ID:
		 if (!zdr_EXCHANGE_ID4res (zdrs, &objp->nfs_resop4_u.opexchangeid))
			 return FALSE;
		break;
	case OP_CREATE_SESSION:
		 if (!zdr_CREATE_SESSION4res (zdrs, &objp->nfs_resop4_u.opcreatesession))
			 return FALSE;
		break;
	case OP_DESTROY_SESSION:
		 if (!zdr_DESTROY_SESSION4res (zdrs, &objp->nfs_resop4_u.opdestroysession))
			 return FALSE;
		break;
	case OP_FREE_STATEID:
		 if (!zdr_FREE_STATEID4res (zdrs, &objp->nfs_resop4_u.opfreestateid))
			 return FALSE;
		break;
	case OP_GET_DIR_DELEGATION:
		 if (!zdr_GET_DIR_DELEGATION4res (zdrs, &objp->nfs_resop4_u.opgetdirdelegation))
			 return FALSE;
		break;
	case OP_GETDEVICEINFO:
		 if (!zdr_GETDEVICEINFO4res (zdrs, &objp->nfs_resop4_u.opgetdeviceinfo))
			 return FALSE;
		break;
	case OP_GETDEVICELIST:
		 if (!zdr_GETDEVICELIST4res (zdrs, &objp->nfs_resop4_u.opgetdevicelist))
			 return FALSE;
		break;
	case OP_LAYOUTCOMMIT:
		 if (!zdr_LAYOUTCOMMIT4res (zdrs, &objp->nfs_resop4_u.oplayoutcommit))
			 return FALSE;
		break;
	case OP_LAYOUTGET:
		 if (!zdr_LAYOUTGET4res (zdrs, &objp->nfs_resop4_u.oplayoutget))
			 return FALSE;
		break;
	case OP_LAYOUTRETURN:
		 if (!zdr_LAYOUTRETURN4res (zdrs, &objp->nfs_resop4_u.oplayoutreturn))
			 return FALSE;
		break;
	case OP_SECINFO_NO_NAME:
		 if (!zdr_SECINFO_NO_NAME4res (zdrs, &objp->nfs_resop4_u.opsecinfononame))
			 return FALSE;
		break;
	case OP_SEQUENCE:
		 if (!zdr_SEQUENCE4res (zdrs, &objp->nfs_resop4_u.opsequence))
			 return FALSE;
		break;
	case OP_SET_SSV:
		 if (!zdr_SET_SSV4res (zdrs, &objp->nfs_resop4_u.opsetssv))
			 return FALSE;
		break;
	case OP_TEST_STATEID:
		 if (!zdr_TEST_STATEID4res (zdrs, &objp->nfs_resop4_u.opteststateid))
			 return FALSE;
		break;
	case OP_WANT_DELEGATION:
		 if (!zdr_WANT_DELEGATION4res (zdrs, &objp->nfs_resop4_u.opwantdelegation))
			 return FALSE;
		break;
	case OP_DESTROY_CLIENTID:
		 if (!zdr_DESTROY_CLIENTID4res (zdrs, &objp->nfs_resop4_u.opdestroyclientid))
			 return FALSE;
		break;
	case OP_RECLAIM_COMPLETE:
		 if (!zdr_RECLAIM_COMPLETE4res (zdrs, &objp->nfs_resop4_u.opreclaimcomplete))
			 return FALSE;
		break;
	case OP_ILLEGAL:
		 if (!zdr_ILLEGAL4res (zdrs, &objp->nfs_resop4_u.opillegal))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_COMPOUND4args (ZDR *zdrs, COMPOUND4args *objp)
{
	

	 if (!zdr_utf8str_cs (zdrs, &objp->tag))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->minorversion))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->argarray.argarray_val, (u_int *) &objp->argarray.argarray_len, ~0,
		sizeof (nfs_argop4), (zdrproc_t) zdr_nfs_argop4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_COMPOUND4res (ZDR *zdrs, COMPOUND4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	 if (!zdr_utf8str_cs (zdrs, &objp->tag))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->resarray.resarray_val, (u_int *) &objp->resarray.resarray_len, ~0,
		sizeof (nfs_resop4), (zdrproc_t) zdr_nfs_resop4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CB_GETATTR4args (ZDR *zdrs, CB_GETATTR4args *objp)
{
	

	 if (!zdr_nfs_fh4 (zdrs, &objp->fh))
		 return FALSE;
	 if (!zdr_bitmap4 (zdrs, &objp->attr_request))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CB_GETATTR4resok (ZDR *zdrs, CB_GETATTR4resok *objp)
{
	

	 if (!zdr_fattr4 (zdrs, &objp->obj_attributes))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CB_GETATTR4res (ZDR *zdrs, CB_GETATTR4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	switch (objp->status) {
	case NFS4_OK:
		 if (!zdr_CB_GETATTR4resok (zdrs, &objp->CB_GETATTR4res_u.resok4))
			 return FALSE;
		break;
	default:
		break;
	}
	return TRUE;
}

uint32_t
zdr_CB_RECALL4args (ZDR *zdrs, CB_RECALL4args *objp)
{
	

	 if (!zdr_stateid4 (zdrs, &objp->stateid))
		 return FALSE;
	 if (!zdr_bool (zdrs, &objp->truncate))
		 return FALSE;
	 if (!zdr_nfs_fh4 (zdrs, &objp->fh))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CB_RECALL4res (ZDR *zdrs, CB_RECALL4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CB_ILLEGAL4res (ZDR *zdrs, CB_ILLEGAL4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_cb_opnum4 (ZDR *zdrs, nfs_cb_opnum4 *objp)
{
	

	 if (!zdr_enum (zdrs, (enum_t *) objp))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_nfs_cb_argop4 (ZDR *zdrs, nfs_cb_argop4 *objp)
{
	

	 if (!zdr_u_int (zdrs, &objp->argop))
		 return FALSE;
	switch (objp->argop) {
	case OP_CB_GETATTR:
		 if (!zdr_CB_GETATTR4args (zdrs, &objp->nfs_cb_argop4_u.opcbgetattr))
			 return FALSE;
		break;
	case OP_CB_RECALL:
		 if (!zdr_CB_RECALL4args (zdrs, &objp->nfs_cb_argop4_u.opcbrecall))
			 return FALSE;
		break;
	case OP_CB_ILLEGAL:
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_nfs_cb_resop4 (ZDR *zdrs, nfs_cb_resop4 *objp)
{
	

	 if (!zdr_u_int (zdrs, &objp->resop))
		 return FALSE;
	switch (objp->resop) {
	case OP_CB_GETATTR:
		 if (!zdr_CB_GETATTR4res (zdrs, &objp->nfs_cb_resop4_u.opcbgetattr))
			 return FALSE;
		break;
	case OP_CB_RECALL:
		 if (!zdr_CB_RECALL4res (zdrs, &objp->nfs_cb_resop4_u.opcbrecall))
			 return FALSE;
		break;
	case OP_CB_ILLEGAL:
		 if (!zdr_CB_ILLEGAL4res (zdrs, &objp->nfs_cb_resop4_u.opcbillegal))
			 return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

uint32_t
zdr_CB_COMPOUND4args (ZDR *zdrs, CB_COMPOUND4args *objp)
{
	

	 if (!zdr_utf8str_cs (zdrs, &objp->tag))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->minorversion))
		 return FALSE;
	 if (!zdr_uint32_t (zdrs, &objp->callback_ident))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->argarray.argarray_val, (u_int *) &objp->argarray.argarray_len, ~0,
		sizeof (nfs_cb_argop4), (zdrproc_t) zdr_nfs_cb_argop4))
		 return FALSE;
	return TRUE;
}

uint32_t
zdr_CB_COMPOUND4res (ZDR *zdrs, CB_COMPOUND4res *objp)
{
	

	 if (!zdr_nfsstat4 (zdrs, &objp->status))
		 return FALSE;
	 if (!zdr_utf8str_cs (zdrs, &objp->tag))
		 return FALSE;
	 if (!zdr_array (zdrs, (char **)&objp->resarray.resarray_val, (u_int *) &objp->resarray.resarray_len, ~0,
		sizeof (nfs_cb_resop4), (zdrproc_t) zdr_nfs_cb_resop4))
		 return FALSE;
	return TRUE;
}
