# Pragmas.
use strict;
use warnings;

# Modules.
use inc::Module::Install;

# Definition.
abstract 'Interface to the Kuala Lumpur urban monorail system map.';
author 'Michal Spacek <skim@cpan.org>';
install_share 'share';
license 'bsd';
license 'artistic_2';
name 'Map-Tube-KualaLumpur';
readme_from 'KualaLumpur.pm';
requires 'File::Share' => 0;
requires 'Map::Tube' => '2.96';
requires 'Moo' => 0;
requires 'namespace::clean' => 0;
requires 'perl' => '5.8.0';
resources 'bugtracker' => 'https://rt.cpan.org/Public/Dist/Display.html'.
	'?Name=Map-Tube-KualaLumpur';
resources 'homepage' => 'https://github.com/tupinek/Map-Tube-KualaLumpur';
resources 'repository' => 'git://github.com/tupinek/Map-Tube-KualaLumpur';
test_requires 'English' => 0;
test_requires 'File::Object' => 0.08;
test_requires 'Test::Map::Tube' => 0.07;
test_requires 'Test::More' => 0;
test_requires 'Test::NoWarnings' => 0;
test_requires 'Test::Pod' => 0;
test_requires 'Test::Pod::Coverage' => 0;
tests_recursive;
version '0.02';

# Run.
WriteAll();
