# Generated by default/object.tt
package Paws::LexModelsV2::SlotSummary;
  use Moose;
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedDateTime', traits => ['NameInRequest']);
  has SlotConstraint => (is => 'ro', isa => 'Str', request_name => 'slotConstraint', traits => ['NameInRequest']);
  has SlotId => (is => 'ro', isa => 'Str', request_name => 'slotId', traits => ['NameInRequest']);
  has SlotName => (is => 'ro', isa => 'Str', request_name => 'slotName', traits => ['NameInRequest']);
  has SlotTypeId => (is => 'ro', isa => 'Str', request_name => 'slotTypeId', traits => ['NameInRequest']);
  has ValueElicitationPromptSpecification => (is => 'ro', isa => 'Paws::LexModelsV2::PromptSpecification', request_name => 'valueElicitationPromptSpecification', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::SlotSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::SlotSummary object:

  $service_obj->Method(Att1 => { Description => $value, ..., ValueElicitationPromptSpecification => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::SlotSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Summary information about a slot, a value that the bot elicits from the
user.

=head1 ATTRIBUTES


=head2 Description => Str

The description of the slot.


=head2 LastUpdatedDateTime => Str

The timestamp of the last date and time that the slot was updated.


=head2 SlotConstraint => Str

Whether the slot is required or optional. An intent is complete when
all required slots are filled.


=head2 SlotId => Str

The unique identifier of the slot.


=head2 SlotName => Str

The name given to the slot.


=head2 SlotTypeId => Str

The unique identifier for the slot type that defines the values for the
slot.


=head2 ValueElicitationPromptSpecification => L<Paws::LexModelsV2::PromptSpecification>

Prompts that are sent to the user to elicit a value for the slot.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

